/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.slideshow;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.swing.JFrame;
import org.apache.commons.lang.SystemUtils;

public class FullscreenUtility {
    protected JFrame window;
    protected boolean fullscreen = false;

    public FullscreenUtility(JFrame frame) {
        this.window = frame;
    }

    public void setFullscreen(boolean fullscreen) {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (this.fullscreen != fullscreen) {
            this.fullscreen = fullscreen;
            if (!fullscreen) {
                this.window.setVisible(false);
                this.window.dispose();
                this.window.setUndecorated(false);
                device.setFullScreenWindow(null);
                this.window.setLocationRelativeTo(null);
                this.window.setResizable(true);
                this.window.setVisible(true);
            } else {
                this.window.setVisible(false);
                this.window.dispose();
                this.window.setUndecorated(true);
                this.window.setResizable(false);
                this.window.setAlwaysOnTop(false);
                device.setFullScreenWindow(this.window);
                if (SystemUtils.IS_JAVA_1_7 && SystemUtils.IS_OS_MAC_OSX) {
                    System.err.println("Applying first responder fix");
                    this.window.setVisible(false);
                }
                this.window.setVisible(true);
            }
            this.window.repaint();
        }
    }
}

