/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.slideshow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;
import org.openimaj.audio.AudioStream;
import org.openimaj.content.slideshow.Slide;
import org.openimaj.image.MBFImage;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.xuggle.XuggleAudio;
import org.openimaj.video.xuggle.XuggleVideo;

public class AudioVideoSlide
implements Slide {
    private URL url;
    private VideoDisplay.EndAction endAction;
    private VideoDisplay<MBFImage> display;

    public AudioVideoSlide(URL url, VideoDisplay.EndAction endAction) throws IOException {
        if (url.getProtocol().startsWith("jar")) {
            File tmp = File.createTempFile("movie", ".tmp");
            tmp.deleteOnExit();
            FileUtils.copyURLToFile((URL)url, (File)tmp);
            url = tmp.toURI().toURL();
        }
        this.url = url;
        this.endAction = endAction;
    }

    @Override
    public Component getComponent(int width, int height) throws IOException {
        JPanel base = new JPanel();
        base.setOpaque(false);
        base.setPreferredSize(new Dimension(width, height));
        base.setLayout(new GridBagLayout());
        try {
            XuggleVideo video = new XuggleVideo(this.url, true);
            XuggleAudio audio = new XuggleAudio(this.url);
            this.display = VideoDisplay.createVideoDisplay((Video)video, (AudioStream)audio, (JComponent)base);
            this.display.setEndAction(this.endAction);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return base;
    }

    @Override
    public void close() {
        this.display.close();
    }
}

