/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean stopOnError;
    private boolean autoCommit;
    private PrintWriter logWriter = new PrintWriter(System.out);
    private PrintWriter errorLogWriter = new PrintWriter(System.err);
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;
    private static final String DELIMITER_LINE_REGEX = "(?i)DELIMITER.+";
    private static final String DELIMITER_LINE_SPLIT_REGEX = "(?i)DELIMITER";

    public ScriptRunner(Connection connection, boolean autoCommit, boolean stopOnError) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public void setErrorLogWriter(PrintWriter errorLogWriter) {
        this.errorLogWriter = errorLogWriter;
    }

    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            LineNumberReader lineReader = new LineNumberReader(reader);
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                Matcher matcher;
                Pattern pattern;
                String trimmedLine;
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((trimmedLine = line.trim()).startsWith("--")) {
                    this.println(trimmedLine);
                    continue;
                }
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    pattern = Pattern.compile(DELIMITER_LINE_REGEX);
                    matcher = pattern.matcher(trimmedLine);
                    if (matcher.matches()) {
                        this.setDelimiter(trimmedLine.split(DELIMITER_LINE_SPLIT_REGEX)[1].trim(), this.fullLineDelimiter);
                        line = lineReader.readLine();
                        if (line == null) break;
                        trimmedLine = line.trim();
                    }
                    command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                    command.append(" ");
                    Statement statement = conn.createStatement();
                    this.println(command);
                    boolean hasResults = false;
                    if (this.stopOnError) {
                        hasResults = statement.execute(command.toString());
                    } else {
                        try {
                            statement.execute(command.toString());
                        }
                        catch (SQLException e) {
                            e.fillInStackTrace();
                            this.printlnError("Error executing: " + command);
                            this.printlnError(e);
                        }
                    }
                    if (this.autoCommit && !conn.getAutoCommit()) {
                        conn.commit();
                    }
                    ResultSet rs = statement.getResultSet();
                    if (hasResults && rs != null) {
                        int i;
                        ResultSetMetaData md = rs.getMetaData();
                        int cols = md.getColumnCount();
                        for (i = 0; i < cols; ++i) {
                            String name = md.getColumnLabel(i);
                            this.print(name + "\t");
                        }
                        this.println("");
                        while (rs.next()) {
                            for (i = 0; i < cols; ++i) {
                                String value = rs.getString(i);
                                this.print(value + "\t");
                            }
                            this.println("");
                        }
                    }
                    command = null;
                    try {
                        statement.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Thread.yield();
                    continue;
                }
                pattern = Pattern.compile(DELIMITER_LINE_REGEX);
                matcher = pattern.matcher(trimmedLine);
                if (matcher.matches()) {
                    this.setDelimiter(trimmedLine.split(DELIMITER_LINE_SPLIT_REGEX)[1].trim(), this.fullLineDelimiter);
                    line = lineReader.readLine();
                    if (line == null) break;
                    trimmedLine = line.trim();
                }
                command.append(line);
                command.append(" ");
            }
            if (!this.autoCommit) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            e.fillInStackTrace();
            this.printlnError("Error executing: " + command);
            this.printlnError(e);
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            this.printlnError("Error executing: " + command);
            this.printlnError(e);
            throw e;
        }
        finally {
            conn.rollback();
            this.flush();
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }

    private void print(Object o) {
        if (this.logWriter != null) {
            System.out.print(o);
        }
    }

    private void println(Object o) {
        if (this.logWriter != null) {
            this.logWriter.println(o);
        }
    }

    private void printlnError(Object o) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(o);
        }
    }

    private void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
        if (this.errorLogWriter != null) {
            this.errorLogWriter.flush();
        }
    }
}

