/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.flat;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.openforis.commons.io.csv.CsvProcessor;
import org.openforis.commons.io.flat.Field;
import org.openforis.commons.io.flat.FlatDataStream;
import org.openforis.commons.io.flat.FlatRecord;

public abstract class FlatDataWriter
extends CsvProcessor
implements Closeable {
    protected long linesWritten = 0L;
    protected boolean headersWritten = false;

    public void writeAll(FlatDataStream in) throws IOException {
        FlatRecord r = in.nextRecord();
        if (r == null) {
            return;
        }
        this.setFields(in.getFields());
        while (r != null) {
            this.writeNext(r);
            r = in.nextRecord();
        }
    }

    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public void writeNext(FlatRecord r) {
        Object[] line = r.toArray();
        this.writeNext(line);
    }

    public void writeNext(List<String> line) {
        this.writeNext(line.toArray(new Object[line.size()]));
    }

    public void writeNext(Object[] line) {
        this.writeNextInternal(line);
        ++this.linesWritten;
    }

    protected abstract void writeNextInternal(Object[] var1);

    public void writeHeaders(List<String> headers) {
        this.writeHeaders(headers.toArray(new String[headers.size()]));
    }

    public void writeHeaders(String[] headers) {
        if (this.headersWritten) {
            throw new IllegalStateException("Headers already written");
        }
        Field[] headersFields = new Field[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            headersFields[i] = new Field(headers[i], Field.Type.STRING, i);
        }
        this.setFields(headersFields);
        this.writeNext(headers);
        this.headersWritten = true;
    }

    public long getLinesWritten() {
        return this.linesWritten;
    }

    public boolean isHeadersWritten() {
        return this.headersWritten;
    }
}

