/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.openforis.commons.io.OpenForisIOUtils;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.csv.CsvReaderDelegate;

class OpenCsvReader
extends CsvReaderDelegate {
    private final CSVReader csv;
    private File file;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';

    public OpenCsvReader(File file, String charsetName, char separator, char quoteChar, CsvReader csvReader) throws FileNotFoundException {
        this(OpenForisIOUtils.toReader(file, charsetName), separator, quoteChar, csvReader);
        this.file = file;
    }

    @Deprecated
    public OpenCsvReader(Reader reader, char separator, char quoteChar, CsvReader csvReader) {
        super(csvReader);
        CSVParser parser = new CSVParserBuilder().withSeparator(separator).withQuoteChar(quoteChar).build();
        this.csv = new CSVReaderBuilder(reader).withCSVParser((ICSVParser)parser).build();
    }

    @Override
    public String[] readHeadersInternal() throws IOException {
        try {
            return this.csv.readNext();
        }
        catch (CsvValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected String[] line(long lineIdx) throws IOException {
        try {
            return this.csv.readNext();
        }
        catch (CsvValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.csv != null) {
            this.csv.close();
        }
    }

    @Override
    public int size() throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("Source file not properly initialized");
        }
        try (BufferedReader lineReader = null;){
            lineReader = new LineNumberReader(new FileReader(this.file));
            ((LineNumberReader)lineReader).skip(Long.MAX_VALUE);
            int n = ((LineNumberReader)lineReader).getLineNumber();
            return n;
        }
    }
}

