/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openforis.commons.io.flat.Field;

public abstract class CsvProcessor {
    private DateFormat dateFormat;
    private Map<String, Field> fieldsByName;
    private List<String> fieldNames;

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.setDateFormat("yyyy-MM-dd");
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateFormat(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(new ArrayList<Field>(this.fieldsByName.values()));
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFields(List<Field> fields) {
        this.setFields(fields.toArray(new Field[fields.size()]));
    }

    protected void setFields(Field[] fields) {
        this.fieldNames = new ArrayList<String>(fields.length);
        this.fieldsByName = new LinkedHashMap<String, Field>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            String name = f.getName();
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Empty column heading at index: " + i);
            }
            if (this.fieldNames.contains(name)) {
                throw new IllegalArgumentException("Duplicate header: " + name);
            }
            this.fieldsByName.put(name, f);
            this.fieldNames.add(name);
        }
    }

    protected void setFieldNames(String[] fieldNames) {
        Field[] fields = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            Field c;
            String name = fieldNames[i];
            fields[i] = c = new Field(name, Field.Type.STRING, i);
        }
        this.setFields(fields);
    }
}

