/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openforis.commons.io.flat.Field;
import org.openforis.commons.io.flat.FlatDataWriter;

public class ExcelFlatValuesWriter
extends FlatDataWriter {
    private Workbook workbook = new XSSFWorkbook();
    private Sheet sheet = this.workbook.createSheet("sheet1");
    private OutputStream os;

    public ExcelFlatValuesWriter(OutputStream output) throws UnsupportedEncodingException {
        this.os = output;
    }

    @Override
    protected void writeNextInternal(Object[] values) {
        Row row = this.sheet.createRow(Long.valueOf(this.linesWritten).intValue());
        for (int i = 0; i < this.getFields().size() && i < values.length; ++i) {
            Cell cell = row.createCell(i);
            Field field = this.getFields().get(i);
            Object value = values[i];
            switch (field.getType()) {
                case DECIMAL: 
                case INTEGER: {
                    cell.setCellType(CellType.NUMERIC);
                    break;
                }
                default: {
                    cell.setCellType(CellType.STRING);
                }
            }
            if (value == null) {
                cell.setCellValue((String)null);
                continue;
            }
            if (value instanceof Number && (field.getType() == Field.Type.DECIMAL || field.getType() == Field.Type.INTEGER)) {
                cell.setCellValue(((Number)value).doubleValue());
                continue;
            }
            cell.setCellValue(value.toString());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.workbook.write(this.os);
        this.workbook.close();
    }
}

