/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hl7.HL7MLLPCodec;
import org.apache.camel.component.mina.MinaComponent;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaEndpointConfigurer;
import org.apache.camel.spi.PropertyConfigurer;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptableComponent;
import org.openehealth.ipf.platform.camel.ihe.core.Interceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2ConfigurationHolder;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MllpComponent<ConfigType extends MllpEndpointConfiguration, AuditDatasetType extends MllpAuditDataset>
extends MinaComponent
implements InterceptableComponent,
Hl7v2ConfigurationHolder<AuditDatasetType> {
    private static final transient Logger LOG = LoggerFactory.getLogger(MllpComponent.class);
    public static final String ACK_TYPE_CODE_HEADER = "ipf.hl7v2.AckTypeCode";
    private static final String DEFAULT_HL7_CODEC_FACTORY_BEAN_NAME = "#hl7codec";

    protected MllpComponent() {
    }

    protected MllpComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected abstract ConfigType createConfig(String var1, Map<String, Object> var2) throws Exception;

    protected abstract MllpEndpoint<?, ?, ?> createEndpoint(MinaEndpoint var1, ConfigType var2);

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (parameters.isEmpty()) {
            parameters = new HashMap<String, Object>();
        }
        parameters.put("sync", true);
        parameters.put("lazySessionCreation", true);
        parameters.put("transferExchange", false);
        if (!parameters.containsKey("codec")) {
            parameters.put("codec", DEFAULT_HL7_CODEC_FACTORY_BEAN_NAME);
        }
        ConfigType config = this.createConfig(uri, parameters);
        Charset charset = null;
        try {
            HL7MLLPCodec codecFactory = (HL7MLLPCodec)((MllpEndpointConfiguration)((Object)config)).getCodecFactory();
            if (codecFactory == null) {
                codecFactory = new HL7MLLPCodec();
                LOG.warn("No HL7 codec factory found, creating new default instance {}", (Object)codecFactory);
            }
            charset = codecFactory.getCharset();
        }
        catch (ClassCastException cce) {
            LOG.warn("Unsupported HL7 codec factory type {}, using default character set", (Object)((MllpEndpointConfiguration)((Object)config)).getCodecFactory().getClass().getName());
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        parameters.put("encoding", charset.name());
        Endpoint endpoint = super.createEndpoint(uri, "tcp://" + remaining, parameters);
        MinaEndpoint minaEndpoint = (MinaEndpoint)endpoint;
        return this.createEndpoint(minaEndpoint, config);
    }

    public List<Interceptor<?>> getAdditionalConsumerInterceptors() {
        return Collections.emptyList();
    }

    public List<Interceptor<?>> getAdditionalProducerInterceptors() {
        return Collections.emptyList();
    }

    public PropertyConfigurer getEndpointPropertyConfigurer() {
        return new MinaEndpointConfigurer();
    }
}

