/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeCallbackSSLFilter
extends SslFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandshakeCallbackSSLFilter.class);
    private Callback handshakeExceptionCallback;

    public HandshakeCallbackSSLFilter(SSLContext sslContext) {
        super(sslContext);
    }

    public void setHandshakeExceptionCallback(Callback handshakeExceptionCallback) {
        this.handshakeExceptionCallback = handshakeExceptionCallback;
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws SSLException {
        try {
            super.messageReceived(nextFilter, session, message);
        }
        catch (SSLHandshakeException e) {
            this.handshakeExceptionCallback.run(session, e.getMessage());
            try {
                this.exceptionCaught(nextFilter, session, e.getCause());
            }
            catch (Exception e1) {
                LOGGER.warn("SSLHandshakeException {} on Session: {}", (Object)e, (Object)session);
            }
        }
    }

    public static interface Callback {
        public void run(IoSession var1, String var2);
    }
}

