/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer;

import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.core.payload.ExpressionResolver;
import org.openehealth.ipf.commons.ihe.core.payload.SpringExpressionResolver;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorFactorySupport;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.MllpPayloadLoggerBase;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerStringProcessingInterceptor;

public class ProducerInPayloadLoggerInterceptor
extends InterceptorSupport<MllpEndpoint<?, ?, ?>> {
    private final MllpPayloadLoggerBase base = new MllpPayloadLoggerBase();

    public ProducerInPayloadLoggerInterceptor(String fileNamePattern) {
        this((ExpressionResolver)new SpringExpressionResolver(fileNamePattern));
    }

    public ProducerInPayloadLoggerInterceptor(ExpressionResolver resolver) {
        this.addBefore(new String[]{ProducerStringProcessingInterceptor.class.getName()});
        this.setExpressionResolver(resolver);
    }

    public void process(Exchange exchange) throws Exception {
        this.getWrappedProcessor().process(exchange);
        if (this.canProcess()) {
            this.logPayload(exchange, (InteractionId)((MllpEndpoint)this.getEndpoint()).getInteractionId());
        }
    }

    public void logPayload(Exchange exchange, InteractionId interactionId) {
        this.base.logPayload(exchange, interactionId);
    }

    public boolean canProcess() {
        return this.base.canProcess();
    }

    public void resetErrorCount() {
        this.base.resetErrorCount();
    }

    public boolean isEnabled() {
        return this.base.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.base.setEnabled(enabled);
    }

    public int getErrorCountLimit() {
        return this.base.getErrorCountLimit();
    }

    public void setErrorCountLimit(int errorCountLimit) {
        this.base.setErrorCountLimit(errorCountLimit);
    }

    public ExpressionResolver getExpressionResolver() {
        return this.base.getExpressionResolver();
    }

    public void setExpressionResolver(ExpressionResolver resolver) {
        this.base.setExpressionResolver(resolver);
    }

    public static class Factory
    extends InterceptorFactorySupport<MllpEndpoint<?, ?, ?>, ProducerInPayloadLoggerInterceptor> {
        private final ExpressionResolver resolver;
        private boolean enabled = true;

        public Factory(String fileNamePattern) {
            this((ExpressionResolver)new SpringExpressionResolver(fileNamePattern));
        }

        public Factory(ExpressionResolver resolver) {
            super(ProducerInPayloadLoggerInterceptor.class);
            this.resolver = resolver;
        }

        public ProducerInPayloadLoggerInterceptor getNewInstance() {
            ProducerInPayloadLoggerInterceptor interceptor = new ProducerInPayloadLoggerInterceptor(this.resolver);
            interceptor.setEnabled(this.enabled);
            return interceptor;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

