/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.core.payload.ExpressionResolver;
import org.openehealth.ipf.commons.ihe.core.payload.SpringExpressionResolver;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorFactorySupport;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerRequestInteractionSetterInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.MllpPayloadLoggerBase;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerStringProcessingInterceptor;

public class ConsumerInPayloadLoggerInterceptor
extends InterceptorSupport<MllpEndpoint<?, ?, ?>> {
    private final MllpPayloadLoggerBase base = new MllpPayloadLoggerBase();

    public ConsumerInPayloadLoggerInterceptor(String fileNamePattern) {
        this((ExpressionResolver)new SpringExpressionResolver(fileNamePattern));
    }

    public ConsumerInPayloadLoggerInterceptor(ExpressionResolver resolver) {
        this.addBefore(new String[]{ConsumerStringProcessingInterceptor.class.getName()});
        this.addAfter(new String[]{ConsumerRequestInteractionSetterInterceptor.class.getName()});
        this.setExpressionResolver(resolver);
    }

    public void process(Exchange exchange) throws Exception {
        if (this.canProcess()) {
            this.logPayload(exchange, (InteractionId)((MllpEndpoint)this.getEndpoint()).getInteractionId());
        }
        this.getWrappedProcessor().process(exchange);
    }

    public void logPayload(Exchange exchange, InteractionId interactionId) {
        this.base.logPayload(exchange, interactionId);
    }

    public boolean canProcess() {
        return this.base.canProcess();
    }

    public void resetErrorCount() {
        this.base.resetErrorCount();
    }

    public boolean isEnabled() {
        return this.base.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.base.setEnabled(enabled);
    }

    public int getErrorCountLimit() {
        return this.base.getErrorCountLimit();
    }

    public void setErrorCountLimit(int errorCountLimit) {
        this.base.setErrorCountLimit(errorCountLimit);
    }

    public ExpressionResolver getExpressionResolver() {
        return this.base.getExpressionResolver();
    }

    public void setExpressionResolver(ExpressionResolver resolver) {
        this.base.setExpressionResolver(resolver);
    }

    public static class Factory
    extends InterceptorFactorySupport<MllpEndpoint<?, ?, ?>, ConsumerInPayloadLoggerInterceptor> {
        private final ExpressionResolver resolver;
        private boolean enabled = true;

        public Factory(String fileNamePattern) {
            this((ExpressionResolver)new SpringExpressionResolver(fileNamePattern));
        }

        public Factory(ExpressionResolver resolver) {
            super(ConsumerInPayloadLoggerInterceptor.class);
            this.resolver = resolver;
        }

        public ConsumerInPayloadLoggerInterceptor getNewInstance() {
            ConsumerInPayloadLoggerInterceptor interceptor = new ConsumerInPayloadLoggerInterceptor(this.resolver);
            interceptor.setEnabled(this.enabled);
            return interceptor;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

