/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditUtils;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuthenticationFailure;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;

public class ConsumerAuthenticationFailureInterceptor
extends InterceptorSupport<MllpTransactionEndpoint<?>> {
    private final AuditContext auditContext;

    public ConsumerAuthenticationFailureInterceptor(AuditContext auditContext) {
        this.auditContext = Objects.requireNonNull(auditContext);
    }

    public void process(Exchange exchange) throws Exception {
        try {
            this.getWrappedProcessor().process(exchange);
        }
        catch (MllpAuthenticationFailure e) {
            AuditMessage auditMessage = MllpAuditUtils.auditAuthenticationNodeFailure((AuditContext)this.auditContext, (String)e.getMessage(), (String)this.getRemoteAddress(exchange));
            this.auditContext.audit(new AuditMessage[]{auditMessage});
            throw e;
        }
    }

    private String getRemoteAddress(Exchange exchange) {
        InetSocketAddress address = (InetSocketAddress)exchange.getIn().getHeader("CamelMinaRemoteAddress");
        return address != null ? address.getAddress().getHostAddress() : "unknown";
    }
}

