/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import java.security.Principal;
import java.util.Objects;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLSession;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.AuditUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditDataset;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.atna.interceptor.AuditInterceptor;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MllpAuditInterceptorSupport<AuditDatasetType extends MllpAuditDataset>
extends InterceptorSupport<MllpTransactionEndpoint<AuditDatasetType>>
implements AuditInterceptor<AuditDatasetType, MllpTransactionEndpoint<AuditDatasetType>> {
    private static final Logger LOG = LoggerFactory.getLogger(MllpAuditInterceptorSupport.class);
    private final AuditContext auditContext;

    public MllpAuditInterceptorSupport(AuditContext auditContext) {
        this.auditContext = Objects.requireNonNull(auditContext);
    }

    public void process(Exchange exchange) throws Exception {
        block9: {
            block8: {
                Message msg = (Message)exchange.getIn().getBody(Message.class);
                if (!this.isAuditable(msg)) {
                    this.getWrappedProcessor().process(exchange);
                    return;
                }
                AuditDatasetType auditDataset = this.createAndEnrichAuditDatasetFromRequest(exchange, msg);
                this.determineParticipantsAddresses(exchange, (AuditDataset)auditDataset);
                this.extractSslClientUser(exchange, auditDataset);
                boolean failed = false;
                try {
                    this.getWrappedProcessor().process(exchange);
                    Message result = (Message)Exchanges.resultMessage((Exchange)exchange).getBody(Message.class);
                    this.enrichAuditDatasetFromResponse(auditDataset, result);
                    boolean bl = failed = !AuditUtils.isPositiveAck((Message)result);
                    if (auditDataset == null) break block8;
                    auditDataset.setEventOutcomeIndicator(failed ? EventOutcomeIndicator.MajorFailure : EventOutcomeIndicator.Success);
                }
                catch (Exception e) {
                    try {
                        failed = true;
                        if (auditDataset != null) {
                            auditDataset.setEventOutcomeDescription(e.getMessage());
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (auditDataset != null) {
                            auditDataset.setEventOutcomeIndicator(failed ? EventOutcomeIndicator.MajorFailure : EventOutcomeIndicator.Success);
                            this.getAuditStrategy().doAudit(this.auditContext, auditDataset);
                        } else {
                            LOG.warn("Audit dataset is not initialized, no auditing happens");
                        }
                        throw throwable;
                    }
                }
                this.getAuditStrategy().doAudit(this.auditContext, auditDataset);
                break block9;
            }
            LOG.warn("Audit dataset is not initialized, no auditing happens");
        }
    }

    private void extractSslClientUser(Exchange exchange, AuditDatasetType auditDataset) {
        block4: {
            SSLSession sslSession;
            IoSession ioSession = (IoSession)exchange.getIn().getHeader("CamelMinaIoSession", IoSession.class);
            if (ioSession != null && (sslSession = (SSLSession)ioSession.getAttribute((Object)SslFilter.SSL_SESSION)) != null) {
                try {
                    Principal principal = sslSession.getPeerPrincipal();
                    if (principal == null) break block4;
                    String dn = principal.getName();
                    LdapName ldapDN = new LdapName(dn);
                    for (Rdn rdn : ldapDN.getRdns()) {
                        if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                        auditDataset.setSourceUserName((String)rdn.getValue());
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.info("Could not extract CN from client certificate", (Throwable)e);
                }
            }
        }
    }

    private AuditDatasetType createAndEnrichAuditDatasetFromRequest(Exchange exchange, Message msg) {
        MllpAuditDataset auditDataset = (MllpAuditDataset)this.getAuditStrategy().createAuditDataset();
        try {
            AuditUtils.enrichGenericAuditDatasetFromRequest((MllpAuditDataset)auditDataset, (Message)msg);
            return (AuditDatasetType)((MllpAuditDataset)this.getAuditStrategy().enrichAuditDatasetFromRequest((AuditDataset)auditDataset, (Object)msg, exchange.getIn().getHeaders()));
        }
        catch (Exception e) {
            LOG.warn("Exception when enriching audit dataset from request", (Throwable)e);
            return (AuditDatasetType)auditDataset;
        }
    }

    private void enrichAuditDatasetFromResponse(AuditDatasetType auditDataset, Message msg) {
        try {
            this.getAuditStrategy().enrichAuditDatasetFromResponse(auditDataset, (Object)msg, this.auditContext);
        }
        catch (Exception e) {
            LOG.warn("Exception when enriching audit dataset from response", (Throwable)e);
        }
    }

    private boolean isAuditable(Message message) {
        try {
            Terser terser = new Terser(message);
            return (!ArrayUtils.contains((Object[])message.getNames(), (Object)"DSC") || !StringUtils.isNotEmpty((CharSequence)terser.get("DSC-1"))) && ((MllpTransactionEndpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().isAuditable(MessageUtils.eventType((Message)message));
        }
        catch (Exception e) {
            LOG.warn("Exception when determining message auditability, no audit will be performed", (Throwable)e);
            return false;
        }
    }
}

