/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaProducer;
import org.apache.camel.support.DefaultProducer;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.session.IoSession;

public class MllpProducer
extends DefaultProducer {
    private final MinaProducer producer;

    MllpProducer(MinaProducer producer) {
        super((Endpoint)producer.getEndpoint());
        this.producer = producer;
    }

    public void stop() {
        super.stop();
    }

    protected void doStop() throws Exception {
        IoSession session = MllpProducer.getField(this.producer, IoSession.class, "session");
        if (session != null) {
            MllpProducer.invoke(this.producer, "closeSessionIfNeededAndAwaitCloseInHandler", IoSession.class, session);
        }
        IoConnector connector = MllpProducer.getField(this.producer, IoConnector.class, "connector");
        connector.dispose(false);
        super.doStop();
    }

    private static <T> T getField(Object target, Class<T> clazz, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(name);
        field.setAccessible(true);
        return (T)field.get(target);
    }

    private static <T> void invoke(Object target, String name, Class<T> clazz, T arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = target.getClass().getDeclaredMethod(name, clazz);
        method.setAccessible(true);
        method.invoke(target, arg);
    }

    public MinaEndpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    public void process(Exchange exchange) throws Exception {
        this.producer.process(exchange);
    }

    public DefaultIoFilterChainBuilder getFilterChain() {
        return this.producer.getFilterChain();
    }

    public Exchange createExchange() {
        return this.producer.createExchange();
    }

    public void build() {
        this.producer.build();
    }

    public void init() {
        this.producer.init();
    }

    public void start() {
        this.producer.start();
    }

    public void suspend() {
        this.producer.suspend();
    }

    public void resume() {
        this.producer.resume();
    }

    public void shutdown() {
        this.producer.shutdown();
    }

    public ServiceStatus getStatus() {
        return this.producer.getStatus();
    }

    public boolean isNew() {
        return this.producer.isNew();
    }

    public boolean isBuild() {
        return this.producer.isBuild();
    }

    public boolean isInit() {
        return this.producer.isInit();
    }

    public boolean isStarted() {
        return this.producer.isStarted();
    }

    public boolean isStarting() {
        return this.producer.isStarting();
    }

    public boolean isStopping() {
        return this.producer.isStopping();
    }

    public boolean isStopped() {
        return this.producer.isStopped();
    }

    public boolean isSuspending() {
        return this.producer.isSuspending();
    }

    public boolean isSuspended() {
        return this.producer.isSuspended();
    }

    public boolean isRunAllowed() {
        return this.producer.isRunAllowed();
    }

    public boolean isShutdown() {
        return this.producer.isShutdown();
    }

    public boolean isStoppingOrStopped() {
        return this.producer.isStoppingOrStopped();
    }

    public boolean isSuspendingOrSuspended() {
        return this.producer.isSuspendingOrSuspended();
    }

    public boolean isStartingOrStarted() {
        return this.producer.isStartingOrStarted();
    }

    public void close() throws IOException {
        this.producer.close();
    }

    private static interface DoStop {
        public void stop();
    }
}

