/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpExceptionIoFilter
extends IoFilterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MllpExceptionIoFilter.class);
    private final MinaConsumer minaConsumer;

    public MllpExceptionIoFilter(MinaConsumer minaConsumer) {
        this.minaConsumer = minaConsumer;
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        if (!session.isClosing()) {
            if (this.sendResponse(cause)) {
                CamelException exception = new CamelException(cause.getMessage());
                Exchange exchange = this.createExchange((Throwable)exception);
                this.minaConsumer.getExceptionHandler().handleException("", exchange, (Throwable)exception);
                this.sendResponse(session, exchange);
            } else {
                session.closeNow();
                nextFilter.sessionClosed(session);
            }
        }
    }

    private void sendResponse(IoSession session, Exchange exchange) {
        Object response;
        boolean disconnect = this.minaConsumer.getEndpoint().getConfiguration().isDisconnect();
        Object object = response = exchange.hasOut() ? MinaPayloadHelper.getOut((MinaEndpoint)this.minaConsumer.getEndpoint(), (Exchange)exchange) : MinaPayloadHelper.getIn((MinaEndpoint)this.minaConsumer.getEndpoint(), (Exchange)exchange);
        if (response != null) {
            WriteFuture future = session.write(response);
            LOG.trace("Waiting for write to complete for body: {} using session: {}", response, (Object)session);
            if (!future.awaitUninterruptibly(10L, TimeUnit.SECONDS)) {
                LOG.warn("Cannot write body: " + response + " using session: " + session);
            }
        } else {
            LOG.debug("Writing no response");
            disconnect = Boolean.TRUE;
        }
        Boolean close = (Boolean)session.getAttribute((Object)"CamelMinaCloseSessionWhenComplete");
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            LOG.debug("Closing session when complete at address: {}", (Object)this.minaConsumer.getAcceptor().getLocalAddress());
            session.closeNow();
        }
    }

    private Exchange createExchange(Throwable cause) {
        Exchange exchange = this.minaConsumer.getEndpoint().createExchange();
        exchange.setException(cause);
        return exchange;
    }

    private boolean sendResponse(Throwable cause) {
        return !(cause instanceof SSLException);
    }
}

