/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer;

import ca.uhn.hl7v2.util.Terser;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.FragmentationUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerRequestFragmenterInterceptor
extends InterceptorSupport<MllpTransactionEndpoint<?>> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProducerRequestFragmenterInterceptor.class);

    public void process(Exchange exchange) throws Exception {
        int threshold = ((MllpTransactionEndpoint)this.getEndpoint()).getUnsolicitedFragmentationThreshold();
        if (threshold < 3) {
            this.getWrappedProcessor().process(exchange);
            return;
        }
        String request = (String)exchange.getIn().getBody(String.class);
        char fieldSeparator = request.charAt(3);
        List<String> segments = FragmentationUtils.splitString(request, '\r');
        if (segments.size() <= threshold) {
            this.getWrappedProcessor().process(exchange);
            return;
        }
        List<String> mshFields = FragmentationUtils.splitString(segments.get(0), request.charAt(3));
        if (mshFields.size() >= 14 && StringUtils.isNotEmpty((CharSequence)mshFields.get(13))) {
            LOG.warn("MSH-14 is not empty, cannot perform automatic message fragmentation");
            this.getWrappedProcessor().process(exchange);
            return;
        }
        if (segments.get(segments.size() - 1).startsWith("DSC")) {
            List<String> dscFields = FragmentationUtils.splitString(segments.get(segments.size() - 1), request.charAt(3));
            if (dscFields.size() >= 2 && StringUtils.isNotEmpty((CharSequence)dscFields.get(1))) {
                LOG.warn("DSC-1 is not empty, cannot perform automatic message fragmentation");
                this.getWrappedProcessor().process(exchange);
                return;
            }
            segments.remove(segments.size() - 1);
        }
        while (mshFields.size() < 14) {
            mshFields.add("");
        }
        int currentSegmentIndex = 1;
        String continuationPointer = "";
        while (currentSegmentIndex < segments.size()) {
            int currentSegmentsCount = 1;
            StringBuilder sb = new StringBuilder();
            FragmentationUtils.appendSplitSegment(sb, mshFields, fieldSeparator);
            do {
                sb.append(segments.get(currentSegmentIndex)).append('\r');
            } while (++currentSegmentIndex < segments.size() && ++currentSegmentsCount < threshold - 1);
            if (currentSegmentIndex == segments.size() - 1) {
                sb.append(segments.get(currentSegmentIndex++)).append('\r');
            }
            if (currentSegmentIndex < segments.size()) {
                continuationPointer = FragmentationUtils.uniqueId();
                sb.append("DSC").append(fieldSeparator).append(continuationPointer).append(fieldSeparator).append("F\r");
                LOG.debug("Send next fragment, continuation pointer = {}", (Object)continuationPointer);
            }
            exchange.getIn().setBody((Object)sb.toString());
            this.getWrappedProcessor().process(exchange);
            if (currentSegmentIndex >= segments.size()) continue;
            String responseString = (String)Exchanges.resultMessage((Exchange)exchange).getBody(String.class);
            Terser responseTerser = new Terser(((MllpTransactionEndpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().getParser().parse(responseString));
            String messageType = responseTerser.get("MSH-9-1");
            String acknowledgementCode = responseTerser.get("MSA-1");
            String controlId = mshFields.get(9);
            if (!"ACK".equals(messageType)) {
                throw new RuntimeException("Server responded with " + messageType + " instead of ACK to the fragment with control ID " + mshFields.get(9));
            }
            if (!"AA".equals(acknowledgementCode) && !"CA".equals(acknowledgementCode)) {
                LOG.debug("Got NAK response for fragment with control ID {}", (Object)controlId);
                break;
            }
            if (!controlId.equals(responseTerser.get("MSA-2"))) {
                throw new RuntimeException("Expected " + controlId + " in MSA-2, but got " + responseTerser.get("MSA-2"));
            }
            mshFields.set(6, MessageUtils.hl7Now());
            mshFields.set(9, FragmentationUtils.uniqueId());
            mshFields.set(13, continuationPointer);
        }
    }
}

