/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.v25.message.QCN_J01;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerMarshalInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.FragmentationUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerMarshalAndInteractiveResponseReceiverInterceptor
extends InterceptorSupport<MllpTransactionEndpoint<?>> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProducerMarshalAndInteractiveResponseReceiverInterceptor.class);

    public ProducerMarshalAndInteractiveResponseReceiverInterceptor() {
        this.setId(ProducerMarshalInterceptor.class.getName());
    }

    public void process(Exchange exchange) throws Exception {
        Hl7v2TransactionConfiguration config = ((MllpTransactionEndpoint)this.getEndpoint()).getHl7v2TransactionConfiguration();
        Message request = (Message)exchange.getIn().getBody(Message.class);
        Terser requestTerser = null;
        String responseString = null;
        StringBuilder fragmentAccumulator = null;
        boolean supportContinuations = false;
        if (((MllpTransactionEndpoint)this.getEndpoint()).isSupportInteractiveContinuation() && config.isContinuable((requestTerser = new Terser(request)).get("MSH-9-1")) && StringUtils.isEmpty((CharSequence)requestTerser.get("DSC-1"))) {
            supportContinuations = true;
            fragmentAccumulator = new StringBuilder();
        }
        boolean mustSend = true;
        int fragmentsCount = 0;
        int recordsCount = 0;
        while (mustSend) {
            List<String> dscFields;
            mustSend = false;
            exchange.getIn().setBody((Object)request.toString());
            this.getWrappedProcessor().process(exchange);
            responseString = (String)Exchanges.resultMessage((Exchange)exchange).getBody(String.class);
            if (!supportContinuations) continue;
            List<String> segments = FragmentationUtils.splitString(responseString, '\r');
            boolean positiveResponse = false;
            for (String segment : segments) {
                if (!segment.startsWith("MSA")) continue;
                positiveResponse = segment.length() >= 7 && segment.charAt(5) == 'A';
                break;
            }
            if (!positiveResponse) {
                LOG.debug("Not a positive response, cannot perform continuation");
                fragmentsCount = 0;
                recordsCount = 0;
                break;
            }
            if (segments.get(segments.size() - 1).startsWith("DSC") && (dscFields = FragmentationUtils.splitString(segments.get(segments.size() - 1), responseString.charAt(3))).size() >= 3 && "I".equals(dscFields.get(2)) && StringUtils.isNotEmpty((CharSequence)dscFields.get(1))) {
                String continuationPointer = dscFields.get(1);
                LOG.debug("Automatically query interactive fragment {}", (Object)continuationPointer);
                requestTerser.set("DSC-1", continuationPointer);
                requestTerser.set("DSC-2", "I");
                requestTerser.set("MSH-7", MessageUtils.hl7Now());
                requestTerser.set("MSH-10", FragmentationUtils.uniqueId());
                mustSend = true;
            }
            int startDataSegmentIndex = -1;
            int startFooterSegmentIndex = segments.size();
            for (int i = 1; i < segments.size(); ++i) {
                if (config.isDataStartSegment(segments, i)) {
                    ++recordsCount;
                    if (startDataSegmentIndex != -1) continue;
                    startDataSegmentIndex = i;
                    continue;
                }
                if (!config.isFooterStartSegment(segments, i)) continue;
                startFooterSegmentIndex = i;
                break;
            }
            if (startDataSegmentIndex == -1) {
                startDataSegmentIndex = segments.size();
            }
            if (++fragmentsCount == 1) {
                FragmentationUtils.appendSegments(fragmentAccumulator, segments, 0, startDataSegmentIndex);
            }
            FragmentationUtils.appendSegments(fragmentAccumulator, segments, startDataSegmentIndex, startFooterSegmentIndex);
            if (mustSend) continue;
            FragmentationUtils.appendSegments(fragmentAccumulator, segments, startFooterSegmentIndex, segments.size());
        }
        if (fragmentsCount > 1) {
            responseString = fragmentAccumulator.toString();
            if (((MllpTransactionEndpoint)this.getEndpoint()).isAutoCancel()) {
                try {
                    String cancel = ProducerMarshalAndInteractiveResponseReceiverInterceptor.createCancelMessage(request, config.getParser());
                    exchange.getIn().setBody((Object)cancel);
                    this.getWrappedProcessor().process(exchange);
                }
                catch (Exception e) {
                    LOG.warn("Error while preparing and sending automatic cancel message", (Throwable)e);
                }
            }
        }
        Message rsp = config.getParser().parse(responseString);
        if (recordsCount != 0) {
            Terser responseTerser = new Terser(rsp);
            String recordsCountString = Integer.toString(recordsCount);
            responseTerser.set("QAK-4", recordsCountString);
            responseTerser.set("QAK-5", recordsCountString);
            responseTerser.set("QAK-6", "0");
        }
        Exchanges.resultMessage((Exchange)exchange).setBody((Object)rsp);
    }

    public static String createCancelMessage(Message request, Parser parser) throws HL7Exception {
        return request.getVersion().charAt(2) < '4' ? ProducerMarshalAndInteractiveResponseReceiverInterceptor.createCnqMessage(request, parser) : ProducerMarshalAndInteractiveResponseReceiverInterceptor.createQcnJ01Message(request, parser);
    }

    private static String createQcnJ01Message(Message request, Parser parser) throws HL7Exception {
        QCN_J01 cancel = new QCN_J01();
        Segment requestMsh = (Segment)request.get("MSH");
        Segment cancelMsh = (Segment)cancel.get("MSH");
        Terser.set((Segment)cancelMsh, (int)1, (int)0, (int)1, (int)1, (String)Terser.get((Segment)requestMsh, (int)1, (int)0, (int)1, (int)1));
        Terser.set((Segment)cancelMsh, (int)2, (int)0, (int)1, (int)1, (String)Terser.get((Segment)requestMsh, (int)2, (int)0, (int)1, (int)1));
        for (int field = 3; field <= 6; ++field) {
            for (int component = 1; component <= 3; ++component) {
                Terser.set((Segment)cancelMsh, (int)field, (int)0, (int)component, (int)1, (String)Terser.get((Segment)requestMsh, (int)field, (int)0, (int)component, (int)1));
            }
        }
        Terser.set((Segment)cancelMsh, (int)7, (int)0, (int)1, (int)1, (String)MessageUtils.hl7Now());
        Terser.set((Segment)cancelMsh, (int)9, (int)0, (int)1, (int)1, (String)"QCN");
        Terser.set((Segment)cancelMsh, (int)9, (int)0, (int)2, (int)1, (String)"J01");
        Terser.set((Segment)cancelMsh, (int)9, (int)0, (int)3, (int)1, (String)"QCN_J01");
        Terser.set((Segment)cancelMsh, (int)10, (int)0, (int)1, (int)1, (String)FragmentationUtils.uniqueId());
        Terser.set((Segment)cancelMsh, (int)11, (int)0, (int)1, (int)1, (String)"P");
        for (int component = 1; component <= 3; ++component) {
            Terser.set((Segment)cancelMsh, (int)12, (int)0, (int)component, (int)1, (String)Terser.get((Segment)requestMsh, (int)12, (int)0, (int)component, (int)1));
        }
        Segment requestQpd = (Segment)request.get("QPD");
        Segment cancelQid = (Segment)cancel.get("QID");
        Terser.set((Segment)cancelQid, (int)1, (int)0, (int)1, (int)1, (String)Terser.get((Segment)requestQpd, (int)2, (int)0, (int)1, (int)1));
        for (int component = 1; component <= 6; ++component) {
            Terser.set((Segment)cancelQid, (int)2, (int)0, (int)component, (int)1, (String)Terser.get((Segment)requestQpd, (int)1, (int)0, (int)component, (int)1));
        }
        return parser.encode((Message)cancel);
    }

    private static String createCnqMessage(Message request, Parser parser) throws HL7Exception {
        Message cancel = parser.parse(parser.encode(request));
        Segment cancelMsh = (Segment)cancel.get("MSH");
        Terser.set((Segment)cancelMsh, (int)7, (int)0, (int)1, (int)1, (String)MessageUtils.hl7Now());
        Terser.set((Segment)cancelMsh, (int)9, (int)0, (int)2, (int)1, (String)"CNQ");
        Terser.set((Segment)cancelMsh, (int)9, (int)0, (int)3, (int)1, (String)"");
        Terser.set((Segment)cancelMsh, (int)10, (int)0, (int)1, (int)1, (String)FragmentationUtils.uniqueId());
        return parser.encode(cancel);
    }
}

