/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import java.net.InetSocketAddress;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.MllpAuditInterceptorSupport;

public class ConsumerAuditInterceptor<AuditDatasetType extends MllpAuditDataset>
extends MllpAuditInterceptorSupport<AuditDatasetType> {
    public ConsumerAuditInterceptor(AuditContext auditContext) {
        super(auditContext);
    }

    public AuditStrategy<AuditDatasetType> getAuditStrategy() {
        return ((MllpTransactionEndpoint)this.getEndpoint()).getServerAuditStrategy();
    }

    public void determineParticipantsAddresses(Exchange exchange, MllpAuditDataset auditDataset) {
        Message message = exchange.getIn();
        auditDataset.setLocalAddress(ConsumerAuditInterceptor.addressFromHeader(message, "CamelMinaLocalAddress"));
        auditDataset.setRemoteAddress(ConsumerAuditInterceptor.addressFromHeader(message, "CamelMinaRemoteAddress"));
    }

    private static String addressFromHeader(Message message, String headerName) {
        InetSocketAddress address = (InetSocketAddress)message.getHeader(headerName);
        return address != null ? address.getAddress().getHostAddress() : "unknown";
    }
}

