/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.mina.MinaEndpoint;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.atna.AuditableComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;

public abstract class MllpTransactionComponent<AuditDatasetType extends MllpAuditDataset>
extends MllpComponent<MllpTransactionEndpointConfiguration, AuditDatasetType>
implements AuditableComponent<AuditDatasetType> {
    private final Hl7v2InteractionId<AuditDatasetType> interactionId;

    protected MllpTransactionComponent(Hl7v2InteractionId<AuditDatasetType> interactionId) {
        this.interactionId = interactionId;
    }

    protected MllpTransactionComponent(CamelContext camelContext, Hl7v2InteractionId<AuditDatasetType> interactionId) {
        super(camelContext);
        this.interactionId = interactionId;
    }

    @Override
    protected MllpTransactionEndpointConfiguration createConfig(String uri, Map<String, Object> parameters) throws Exception {
        return new MllpTransactionEndpointConfiguration(this, uri, parameters);
    }

    @Override
    protected MllpEndpoint<?, ?, ?> createEndpoint(MinaEndpoint wrappedEndpoint, MllpTransactionEndpointConfiguration config) {
        return new MllpTransactionEndpoint(this, wrappedEndpoint, config);
    }

    public AuditStrategy<AuditDatasetType> getClientAuditStrategy() {
        return this.interactionId.getHl7v2TransactionConfiguration().getClientAuditStrategy();
    }

    public AuditStrategy<AuditDatasetType> getServerAuditStrategy() {
        return this.interactionId.getHl7v2TransactionConfiguration().getServerAuditStrategy();
    }

    public Hl7v2InteractionId<AuditDatasetType> getInteractionId() {
        return this.interactionId;
    }
}

