/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaProducer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.ihe.core.ClientAuthType;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.MllpAuditUtils;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptableEndpoint;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorFactory;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.HL7v2Endpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.HandshakeCallbackSSLFilter;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpConsumer;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpExceptionIoFilter;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpProducer;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerDispatchingInterceptor;

@ManagedResource(description="Managed IPF MLLP ITI Endpoint")
public abstract class MllpEndpoint<ConfigType extends MllpEndpointConfiguration, AuditDatasetType extends MllpAuditDataset, ComponentType extends MllpComponent<ConfigType, AuditDatasetType>>
extends DefaultEndpoint
implements InterceptableEndpoint<ConfigType, ComponentType>,
HL7v2Endpoint<AuditDatasetType> {
    private final ConfigType config;
    private final ComponentType mllpComponent;
    private final MinaEndpoint wrappedEndpoint;

    public MllpEndpoint(ComponentType mllpComponent, MinaEndpoint wrappedEndpoint, ConfigType config) {
        super(wrappedEndpoint.getEndpointUri(), mllpComponent);
        this.mllpComponent = (MllpComponent)((Object)Objects.requireNonNull(mllpComponent));
        this.wrappedEndpoint = Objects.requireNonNull(wrappedEndpoint);
        this.config = (MllpEndpointConfiguration)((Object)Objects.requireNonNull(config));
    }

    public ComponentType getInterceptableComponent() {
        return this.mllpComponent;
    }

    public ConfigType getInterceptableConfiguration() {
        return this.config;
    }

    public Producer doCreateProducer() throws Exception {
        DefaultIoFilterChainBuilder filterChain;
        MinaProducer producer = (MinaProducer)this.wrappedEndpoint.createProducer();
        if (((MllpEndpointConfiguration)((Object)this.config)).getSslContext() != null && !(filterChain = producer.getFilterChain()).contains("ssl")) {
            HandshakeCallbackSSLFilter filter = new HandshakeCallbackSSLFilter(((MllpEndpointConfiguration)((Object)this.config)).getSslContext());
            filter.setUseClientMode(true);
            filter.setHandshakeExceptionCallback(new HandshakeFailureCallback());
            filter.setEnabledProtocols(((MllpEndpointConfiguration)((Object)this.config)).getSslProtocols());
            filter.setEnabledCipherSuites(((MllpEndpointConfiguration)((Object)this.config)).getSslCiphers());
            filterChain.addFirst("ssl", (IoFilter)filter);
        }
        return new MllpProducer(producer);
    }

    public Consumer doCreateConsumer(Processor processor) throws Exception {
        DefaultIoFilterChainBuilder filterChain;
        MinaConsumer consumer = (MinaConsumer)this.wrappedEndpoint.createConsumer(processor);
        if (((MllpEndpointConfiguration)((Object)this.config)).getSslContext() != null && !(filterChain = consumer.getAcceptor().getFilterChain()).contains("ssl")) {
            HandshakeCallbackSSLFilter filter = new HandshakeCallbackSSLFilter(((MllpEndpointConfiguration)((Object)this.config)).getSslContext());
            filter.setNeedClientAuth(((MllpEndpointConfiguration)((Object)this.config)).getClientAuthType() == ClientAuthType.MUST);
            filter.setWantClientAuth(((MllpEndpointConfiguration)((Object)this.config)).getClientAuthType() == ClientAuthType.WANT);
            filter.setHandshakeExceptionCallback(new HandshakeFailureCallback());
            filter.setEnabledProtocols(((MllpEndpointConfiguration)((Object)this.config)).getSslProtocols());
            filter.setEnabledCipherSuites(((MllpEndpointConfiguration)((Object)this.config)).getSslCiphers());
            filterChain.addFirst("ssl", (IoFilter)filter);
        }
        consumer.getAcceptor().getFilterChain().addLast("mllp.exception.filter", (IoFilter)new MllpExceptionIoFilter(consumer));
        return new MllpConsumer(consumer);
    }

    public Hl7v2TransactionConfiguration<AuditDatasetType> getHl7v2TransactionConfiguration() {
        return this.mllpComponent.getHl7v2TransactionConfiguration();
    }

    public NakFactory<AuditDatasetType> getNakFactory() {
        return this.mllpComponent.getNakFactory();
    }

    public Hl7v2InteractionId<AuditDatasetType> getInteractionId() {
        return this.mllpComponent.getInteractionId();
    }

    @ManagedAttribute(description="Support Segment Fragmentation Enabled")
    public boolean isSupportSegmentFragmentation() {
        return ((MllpEndpointConfiguration)((Object)this.config)).isSupportSegmentFragmentation();
    }

    @ManagedAttribute(description="Segment Fragmentation Threshold")
    public int getSegmentFragmentationThreshold() {
        return ((MllpEndpointConfiguration)((Object)this.config)).getSegmentFragmentationThreshold();
    }

    public SSLContext getSslContext() {
        return ((MllpEndpointConfiguration)((Object)this.config)).getSslContext();
    }

    @ManagedAttribute(description="Defined SSL Protocols")
    public String[] getSslProtocols() {
        return ((MllpEndpointConfiguration)((Object)this.config)).getSslProtocols();
    }

    @ManagedAttribute(description="Defined SSL Ciphers")
    public String[] getSslCiphers() {
        return ((MllpEndpointConfiguration)((Object)this.config)).getSslCiphers();
    }

    @ManagedAttribute(description="Component Type Name")
    public String getComponentType() {
        return this.getComponent().getClass().getName();
    }

    @ManagedAttribute(description="Mina Host")
    public String getHost() {
        return this.getConfiguration().getHost();
    }

    @ManagedAttribute(description="Mina Port")
    public int getPort() {
        return this.getConfiguration().getPort();
    }

    @ManagedAttribute(description="Mina Character Set")
    public String getCharsetName() {
        return this.getConfiguration().getCharsetName();
    }

    @ManagedAttribute(description="Mina Timeout")
    public long getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    @ManagedAttribute(description="Mina Filters")
    public String[] getIoFilters() {
        List filters = this.getConfiguration().getFilters();
        return this.toStringArray(filters);
    }

    @ManagedAttribute(description="SSL Secure Enabled")
    public boolean isSslSecure() {
        return this.getSslContext() != null;
    }

    public ClientAuthType getClientAuthType() {
        return ((MllpEndpointConfiguration)((Object)this.config)).getClientAuthType();
    }

    @ManagedAttribute(description="Client Authentication Type")
    public String getClientAuthTypeClass() {
        return this.getClientAuthType().toString();
    }

    public List<InterceptorFactory> getCustomInterceptorFactories() {
        return this.config.getCustomInterceptorFactories();
    }

    public ConsumerDispatchingInterceptor getDispatcher() {
        return ((MllpEndpointConfiguration)((Object)this.config)).getDispatcher();
    }

    @ManagedAttribute(description="Custom Interceptor Factories")
    public String[] getCustomInterceptorFactoryList() {
        return this.toStringArray(this.getCustomInterceptorFactories());
    }

    private String[] toStringArray(List<?> list) {
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).getClass().getCanonicalName();
        }
        return result;
    }

    public void configureProperties(Map options) {
        this.wrappedEndpoint.configureProperties(options);
    }

    public Exchange createExchange() {
        return this.wrappedEndpoint.createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.wrappedEndpoint.createExchange(pattern);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        return this.wrappedEndpoint.createPollingConsumer();
    }

    public boolean equals(Object object) {
        if (object instanceof MllpEndpoint) {
            MllpEndpoint that = (MllpEndpoint)((Object)object);
            return this.wrappedEndpoint.equals((Object)that.getWrappedEndpoint());
        }
        return false;
    }

    public CamelContext getCamelContext() {
        return this.wrappedEndpoint.getCamelContext();
    }

    public Component getComponent() {
        return this.wrappedEndpoint.getComponent();
    }

    public MinaConfiguration getConfiguration() {
        return this.wrappedEndpoint.getConfiguration();
    }

    public String getEndpointKey() {
        return this.wrappedEndpoint.getEndpointKey();
    }

    public String getEndpointUri() {
        return this.wrappedEndpoint.getEndpointUri();
    }

    public ExchangePattern getExchangePattern() {
        return this.wrappedEndpoint.getExchangePattern();
    }

    public int hashCode() {
        return this.wrappedEndpoint.hashCode();
    }

    public boolean isLenientProperties() {
        return this.wrappedEndpoint.isLenientProperties();
    }

    public boolean isSingleton() {
        return this.wrappedEndpoint.isSingleton();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.wrappedEndpoint.setCamelContext(camelContext);
    }

    public void setEndpointUriIfNotSpecified(String value) {
        this.wrappedEndpoint.setEndpointUriIfNotSpecified(value);
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.wrappedEndpoint.setExchangePattern(exchangePattern);
    }

    public String toString() {
        return this.wrappedEndpoint.toString();
    }

    protected ConfigType getConfig() {
        return this.config;
    }

    protected ComponentType getMllpComponent() {
        return this.mllpComponent;
    }

    protected MinaEndpoint getWrappedEndpoint() {
        return this.wrappedEndpoint;
    }

    private class HandshakeFailureCallback
    implements HandshakeCallbackSSLFilter.Callback {
        private HandshakeFailureCallback() {
        }

        @Override
        public void run(IoSession session, String message) {
            if (MllpEndpoint.this.config.isAudit()) {
                String hostAddress = session.getRemoteAddress().toString();
                AuditMessage auditMessage = MllpAuditUtils.auditAuthenticationNodeFailure((AuditContext)MllpEndpoint.this.config.getAuditContext(), (String)message, (String)hostAddress);
                MllpEndpoint.this.config.getAuditContext().audit(new AuditMessage[]{auditMessage});
            }
        }
    }
}

