/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultConsumer;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MllpConsumer.class);
    private final MinaConsumer consumer;

    public void start() {
        this.consumer.start();
    }

    public Processor getProcessor() {
        return this.consumer.getProcessor();
    }

    public AsyncProcessor getAsyncProcessor() {
        return this.consumer.getAsyncProcessor();
    }

    public boolean isSuspendingOrSuspended() {
        return this.consumer.isSuspendingOrSuspended();
    }

    public IoAcceptor getAcceptor() {
        return this.consumer.getAcceptor();
    }

    public boolean isSuspending() {
        return this.consumer.isSuspending();
    }

    public boolean isStoppingOrStopped() {
        return this.consumer.isStoppingOrStopped();
    }

    public boolean isStopping() {
        return this.consumer.isStopping();
    }

    public Route getRoute() {
        return this.consumer.getRoute();
    }

    public void setRoute(Route route) {
        this.consumer.setRoute(route);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.consumer.setExceptionHandler(exceptionHandler);
    }

    public boolean isStopped() {
        return this.consumer.isStopped();
    }

    public boolean isStarting() {
        return this.consumer.isStarting();
    }

    public boolean isRunAllowed() {
        return this.consumer.isRunAllowed();
    }

    public void setAcceptor(IoAcceptor acceptor) {
        this.consumer.setAcceptor(acceptor);
    }

    public void shutdown() {
        this.consumer.shutdown();
    }

    public UnitOfWork createUoW(Exchange exchange) throws Exception {
        return this.consumer.createUoW(exchange);
    }

    public ServiceStatus getStatus() {
        return this.consumer.getStatus();
    }

    public void resume() {
        this.consumer.resume();
    }

    public ExceptionHandler getExceptionHandler() {
        return this.consumer.getExceptionHandler();
    }

    public boolean isSuspended() {
        return this.consumer.isSuspended();
    }

    public boolean isStarted() {
        return this.consumer.isStarted();
    }

    public MinaEndpoint getEndpoint() {
        return this.consumer.getEndpoint();
    }

    public void doneUoW(Exchange exchange) {
        this.consumer.doneUoW(exchange);
    }

    public void suspend() {
        this.consumer.suspend();
    }

    MllpConsumer(MinaConsumer consumer) {
        super((Endpoint)consumer.getEndpoint(), consumer.getProcessor());
        this.consumer = consumer;
    }

    public void stop() {
        this.consumer.stop();
    }

    protected void doStop() throws Exception {
        super.doStop();
        IoAcceptor ioAcceptor = this.getAcceptor();
        if (ioAcceptor != null) {
            for (IoSession ss : ioAcceptor.getManagedSessions().values()) {
                CloseFuture future = ss.closeNow();
                if (future.awaitUninterruptibly(1000L)) continue;
                LOG.warn("Could not close IoSession, consumer may hang");
            }
            ioAcceptor.unbind();
            ioAcceptor.dispose(false);
        }
    }
}

