/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class FragmentationUtils {
    public static List<String> splitString(String s, char c) {
        int pos;
        ArrayList<String> result = new ArrayList<String>();
        int startPos = 0;
        while ((pos = s.indexOf(c, startPos)) != -1) {
            result.add(s.substring(startPos, pos));
            startPos = pos + 1;
        }
        if (startPos != s.length()) {
            result.add(s.substring(startPos));
        }
        return result;
    }

    public static String ensureMaximalSegmentsLength(String message, int maxLength) {
        if (maxLength == -1) {
            return message;
        }
        if (maxLength <= 4) {
            throw new IllegalArgumentException("maximal length must be greater than 4");
        }
        List<String> segments = FragmentationUtils.splitString(message, '\r');
        boolean needProcess = false;
        for (String segment : segments) {
            if (segment.length() <= maxLength) continue;
            needProcess = true;
            break;
        }
        if (!needProcess) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        String prefix = "ADD" + message.charAt(3);
        int restLength = maxLength - prefix.length();
        for (String segment : segments) {
            if (segment.length() <= maxLength) {
                sb.append(segment).append('\r');
                continue;
            }
            sb.append(segment, 0, maxLength).append('\r');
            int startPos = maxLength;
            while (startPos + restLength <= segment.length()) {
                sb.append(prefix).append(segment, startPos, startPos + restLength).append('\r');
                startPos += restLength;
            }
            if (startPos >= segment.length()) continue;
            sb.append(prefix).append(segment.substring(startPos)).append('\r');
        }
        return sb.toString();
    }

    public static void appendSplitSegment(StringBuilder sb, List<String> fields, char fieldSeparator) {
        for (String field : fields) {
            sb.append(field).append(fieldSeparator);
        }
        int len = sb.length();
        while (sb.charAt(--len) == fieldSeparator) {
            sb.setLength(len);
        }
        sb.append('\r');
    }

    public static void appendSegments(StringBuilder sb, List<String> segments, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            sb.append(segments.get(i)).append('\r');
        }
    }

    public static CharSequence joinSegments(List<String> segments, int startIndex, int endIndex) {
        StringBuilder sb = new StringBuilder();
        FragmentationUtils.appendSegments(sb, segments, startIndex, endIndex);
        return sb;
    }

    public static String keyString(String ... pieces) {
        StringBuilder sb = new StringBuilder(pieces[0]);
        for (int i = 1; i < pieces.length; ++i) {
            sb.append('\u0000').append(pieces[i]);
        }
        return sb.toString();
    }

    public static String uniqueId() {
        return UUID.randomUUID().toString();
    }
}

