/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.apache.camel.component.mina2.Mina2Producer;
import org.apache.camel.impl.DefaultProducer;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MllpProducer.class);
    private final Mina2Producer producer;

    MllpProducer(Mina2Producer producer) {
        super((Endpoint)producer.getEndpoint());
        this.producer = producer;
    }

    public void stop() throws Exception {
        super.stop();
    }

    protected void doStop() throws Exception {
        IoSession session = MllpProducer.getField(this.producer, IoSession.class, "session");
        if (session != null) {
            MllpProducer.invoke(this.producer, "closeSessionIfNeededAndAwaitCloseInHandler", IoSession.class, session);
        }
        IoConnector connector = MllpProducer.getField(this.producer, IoConnector.class, "connector");
        connector.dispose(false);
        super.doStop();
    }

    private static <T> T getField(Object target, Class<T> clazz, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = target.getClass().getDeclaredField(name);
        field.setAccessible(true);
        return (T)field.get(target);
    }

    private static <T> void invoke(Object target, String name, Class<T> clazz, T arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = target.getClass().getDeclaredMethod(name, clazz);
        method.setAccessible(true);
        method.invoke(target, arg);
    }

    public Mina2Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public DefaultIoFilterChainBuilder getFilterChain() {
        return this.producer.getFilterChain();
    }

    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    public void process(Exchange arg0) throws Exception {
        this.producer.process(arg0);
    }

    public Exchange createExchange() {
        return this.producer.createExchange();
    }

    public Exchange createExchange(ExchangePattern arg0) {
        return this.producer.createExchange(arg0);
    }

    @Deprecated
    public Exchange createExchange(Exchange arg0) {
        return this.producer.createExchange(arg0);
    }

    public ServiceStatus getStatus() {
        return this.producer.getStatus();
    }

    public String getVersion() {
        return this.producer.getVersion();
    }

    public boolean isRunAllowed() {
        return this.producer.isRunAllowed();
    }

    public boolean isStarted() {
        return this.producer.isStarted();
    }

    public boolean isStarting() {
        return this.producer.isStarting();
    }

    public boolean isStopped() {
        return this.producer.isStopped();
    }

    public boolean isStopping() {
        return this.producer.isStopping();
    }

    public boolean isStoppingOrStopped() {
        return this.producer.isStoppingOrStopped();
    }

    public boolean isSuspended() {
        return this.producer.isSuspended();
    }

    public boolean isSuspending() {
        return this.producer.isSuspending();
    }

    public boolean isSuspendingOrSuspended() {
        return this.producer.isSuspendingOrSuspended();
    }

    public void resume() throws Exception {
        this.producer.resume();
    }

    public void shutdown() throws Exception {
        this.producer.shutdown();
    }

    public void start() throws Exception {
        this.producer.start();
    }

    public void suspend() throws Exception {
        this.producer.suspend();
    }

    private static interface DoStop {
        public void stop();
    }
}

