/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.mina2.Mina2Consumer;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.apache.camel.component.mina2.Mina2PayloadHelper;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpExceptionIoFilter
extends IoFilterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MllpExceptionIoFilter.class);
    private final Mina2Consumer mina2Consumer;

    public MllpExceptionIoFilter(Mina2Consumer mina2Consumer) {
        this.mina2Consumer = mina2Consumer;
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        if (!session.isClosing()) {
            if (this.sendResponse(cause)) {
                CamelException exception = new CamelException(cause.getMessage());
                Exchange exchange = this.createExchange((Throwable)exception);
                this.mina2Consumer.getExceptionHandler().handleException("", exchange, (Throwable)exception);
                this.sendResponse(session, exchange);
            } else {
                session.closeNow();
                nextFilter.sessionClosed(session);
            }
        }
    }

    private void sendResponse(IoSession session, Exchange exchange) {
        Boolean close;
        Object response;
        boolean disconnect = this.mina2Consumer.getEndpoint().getConfiguration().isDisconnect();
        Object object = response = exchange.hasOut() ? Mina2PayloadHelper.getOut((Mina2Endpoint)this.mina2Consumer.getEndpoint(), (Exchange)exchange) : Mina2PayloadHelper.getIn((Mina2Endpoint)this.mina2Consumer.getEndpoint(), (Exchange)exchange);
        if (response != null) {
            WriteFuture future = session.write(response);
            LOG.trace("Waiting for write to complete for body: {} using session: {}", response, (Object)session);
            if (!future.awaitUninterruptibly(10L, TimeUnit.SECONDS)) {
                LOG.warn("Cannot write body: " + response + " using session: " + session);
            }
        } else {
            LOG.debug("Writing no response");
            disconnect = Boolean.TRUE;
        }
        if ((close = (Boolean)session.getAttribute((Object)"CamelMina2CloseSessionWhenComplete")) != null) {
            disconnect = close;
        }
        if (disconnect) {
            LOG.debug("Closing session when complete at address: {}", (Object)this.mina2Consumer.getAcceptor().getLocalAddress());
            session.closeNow();
        }
    }

    private Exchange createExchange(Throwable cause) {
        Exchange exchange = this.mina2Consumer.getEndpoint().createExchange();
        exchange.setException(cause);
        return exchange;
    }

    private boolean sendResponse(Throwable cause) {
        return !(cause instanceof SSLException);
    }
}

