/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.jsse.ClientAuthentication;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.openehealth.ipf.commons.ihe.core.ClientAuthType;
import org.openehealth.ipf.platform.camel.ihe.atna.AuditableEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.core.AmbiguousBeanException;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerDispatchingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpEndpointConfiguration
extends AuditableEndpointConfiguration {
    private static final long serialVersionUID = -3604219045768985192L;
    private static final Logger LOG = LoggerFactory.getLogger(MllpEndpointConfiguration.class);
    protected static final String UNKNOWN_URI = "unknown";
    private final ProtocolCodecFactory codecFactory;
    private final SSLContext sslContext;
    private final ClientAuthType clientAuthType;
    private final String[] sslProtocols;
    private final String[] sslCiphers;
    private final boolean supportSegmentFragmentation;
    private final int segmentFragmentationThreshold;
    private final ConsumerDispatchingInterceptor dispatcher;

    protected MllpEndpointConfiguration(MllpComponent<?, ?> component, Map<String, Object> parameters) throws Exception {
        this(component, UNKNOWN_URI, parameters);
    }

    protected MllpEndpointConfiguration(MllpComponent<?, ?> component, String uri, Map<String, Object> parameters) throws Exception {
        super(component, parameters);
        this.codecFactory = (ProtocolCodecFactory)EndpointHelper.resolveReferenceParameter((CamelContext)component.getCamelContext(), (String)((String)parameters.get("codec")), ProtocolCodecFactory.class);
        String sslProtocolsString = (String)component.getAndRemoveParameter(parameters, "sslProtocols", String.class, null);
        String sslCiphersString = (String)component.getAndRemoveParameter(parameters, "sslCiphers", String.class, null);
        this.sslProtocols = sslProtocolsString != null ? sslProtocolsString.split("\\s*,\\s*") : null;
        this.sslCiphers = sslCiphersString != null ? sslCiphersString.split("\\s*,\\s*") : null;
        ClientAuthType configuredClientAuthType = (ClientAuthType)component.getAndRemoveParameter(parameters, "clientAuth", ClientAuthType.class, ClientAuthType.NONE);
        boolean secure = (Boolean)component.getAndRemoveParameter(parameters, "secure", Boolean.TYPE, false);
        SSLContextParameters configuredSslContextParameters = (SSLContextParameters)component.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        SSLContext configuredSslContext = (SSLContext)component.resolveAndRemoveReferenceParameter(parameters, "sslContext", SSLContext.class);
        if (secure || configuredSslContextParameters != null || configuredSslContext != null) {
            LOG.debug("Setting up TLS security for MLLP endpoint {}", (Object)uri);
            if (configuredSslContext == null) {
                if (configuredSslContextParameters == null) {
                    Map sslContextParameterMap = component.getCamelContext().getRegistry().findByTypeWithName(SSLContextParameters.class);
                    if (sslContextParameterMap.size() == 1) {
                        Map.Entry entry = sslContextParameterMap.entrySet().iterator().next();
                        configuredSslContextParameters = (SSLContextParameters)entry.getValue();
                        LOG.debug("Setting up SSLContext from SSLContextParameters bean with name {}", entry.getKey());
                    } else if (sslContextParameterMap.size() > 1) {
                        throw new AmbiguousBeanException(SSLContextParameters.class);
                    }
                } else {
                    LOG.debug("Setting up SSLContext from SSLContextParameters provided in endpoint URI");
                }
                if (configuredSslContextParameters == null) {
                    LOG.debug("Setting up default SSLContext");
                    configuredSslContext = SSLContext.getDefault();
                } else {
                    String clientAuthenticationString;
                    configuredSslContext = configuredSslContextParameters.createSSLContext(component.getCamelContext());
                    if (configuredClientAuthType == null && (clientAuthenticationString = configuredSslContextParameters.getServerParameters().getClientAuthentication()) != null) {
                        ClientAuthentication clientAuthentication = ClientAuthentication.valueOf((String)clientAuthenticationString.toUpperCase());
                        switch (clientAuthentication) {
                            case WANT: {
                                configuredClientAuthType = ClientAuthType.WANT;
                                break;
                            }
                            case REQUIRE: {
                                configuredClientAuthType = ClientAuthType.MUST;
                                break;
                            }
                            case NONE: {
                                configuredClientAuthType = ClientAuthType.NONE;
                            }
                        }
                    }
                }
            }
            this.sslContext = configuredSslContext;
        } else {
            this.sslContext = null;
        }
        this.clientAuthType = configuredClientAuthType;
        this.supportSegmentFragmentation = (Boolean)component.getAndRemoveParameter(parameters, "supportSegmentFragmentation", Boolean.TYPE, false);
        this.segmentFragmentationThreshold = (Integer)component.getAndRemoveParameter(parameters, "segmentFragmentationThreshold", Integer.TYPE, -1);
        this.dispatcher = (ConsumerDispatchingInterceptor)((Object)component.resolveAndRemoveReferenceParameter(parameters, "dispatcher", ConsumerDispatchingInterceptor.class));
    }

    public ProtocolCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ClientAuthType getClientAuthType() {
        return this.clientAuthType;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    public boolean isSupportSegmentFragmentation() {
        return this.supportSegmentFragmentation;
    }

    public int getSegmentFragmentationThreshold() {
        return this.segmentFragmentationThreshold;
    }

    public ConsumerDispatchingInterceptor getDispatcher() {
        return this.dispatcher;
    }
}

