/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2MarshalUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.FragmentationUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;

public class ProducerStringProcessingInterceptor
extends InterceptorSupport<MllpEndpoint<?, ?, ?>> {
    public void process(Exchange exchange) throws Exception {
        Message message;
        String charsetName = ((MllpEndpoint)this.getEndpoint()).getCharsetName();
        exchange.setProperty("CamelCharsetName", (Object)charsetName);
        boolean supportSegmentFragmentation = ((MllpEndpoint)this.getEndpoint()).isSupportSegmentFragmentation();
        int segmentFragmentationThreshold = ((MllpEndpoint)this.getEndpoint()).getSegmentFragmentationThreshold();
        if (supportSegmentFragmentation && segmentFragmentationThreshold >= 5) {
            message = exchange.getIn();
            String s = (String)message.getBody(String.class);
            s = FragmentationUtils.ensureMaximalSegmentsLength(s, segmentFragmentationThreshold);
            message.setBody((Object)s);
        }
        this.getWrappedProcessor().process(exchange);
        message = Exchanges.resultMessage((Exchange)exchange);
        message.setBody((Object)Hl7v2MarshalUtils.convertBodyToString((Message)message, (String)charsetName, (boolean)supportSegmentFragmentation));
    }
}

