/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2MarshalUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.FragmentationUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;

public class ConsumerStringProcessingInterceptor
extends InterceptorSupport<MllpEndpoint<?, ?, ?>> {
    public void process(Exchange exchange) throws Exception {
        String charsetName = ((MllpEndpoint)this.getEndpoint()).getCharsetName();
        exchange.setProperty("CamelCharsetName", (Object)charsetName);
        boolean supportSegmentFragmentation = ((MllpEndpoint)this.getEndpoint()).isSupportSegmentFragmentation();
        int segmentFragmentationThreshold = ((MllpEndpoint)this.getEndpoint()).getSegmentFragmentationThreshold();
        Message message = exchange.getIn();
        message.setBody((Object)Hl7v2MarshalUtils.convertBodyToString((Message)message, (String)charsetName, (boolean)supportSegmentFragmentation));
        this.getWrappedProcessor().process(exchange);
        if (supportSegmentFragmentation && segmentFragmentationThreshold >= 5) {
            message = Exchanges.resultMessage((Exchange)exchange);
            String s = (String)message.getBody(String.class);
            s = FragmentationUtils.ensureMaximalSegmentsLength(s, segmentFragmentationThreshold);
            message.setBody((Object)s);
        }
    }
}

