/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.custom;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMllpComponent<AuditDatasetType extends MllpAuditDataset>
extends MllpTransactionComponent<AuditDatasetType> {
    private static final Logger LOG = LoggerFactory.getLogger(CustomMllpComponent.class);
    private Hl7v2TransactionConfiguration transactionConfiguration;

    public CustomMllpComponent() {
        super((Hl7v2InteractionId)null);
    }

    public CustomMllpComponent(CamelContext camelContext) {
        super(camelContext, null);
    }

    @Override
    protected MllpTransactionEndpointConfiguration createConfig(String uri, Map<String, Object> parameters) throws Exception {
        MllpEndpointConfiguration transactionConfig = super.createConfig(uri, (Map)parameters);
        Hl7v2TransactionConfiguration configuration = (Hl7v2TransactionConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "hl7TransactionConfig", Hl7v2TransactionConfiguration.class);
        if (this.transactionConfiguration == null) {
            if (configuration == null) {
                throw new IllegalArgumentException("Must provide hl7TransactionConfig attribute with custom MLLP component");
            }
            this.transactionConfiguration = configuration;
        } else if (configuration != null) {
            throw new IllegalArgumentException("Must not override preconfigured hl7TransactionConfig in custom MLLP component");
        }
        if (transactionConfig.isAudit() && this.getClientAuditStrategy() == null) {
            throw new IllegalArgumentException("Consumer or Producer require ATNA audit, but no clientAuditStrategy is defined for custom MLLP component");
        }
        if (transactionConfig.isAudit() && this.getServerAuditStrategy() == null) {
            throw new IllegalArgumentException("Consumer or Producer require ATNA audit, but no serverAuditStrategy is defined for custom MLLP component");
        }
        return transactionConfig;
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return this.transactionConfiguration;
    }

    @Override
    public AuditStrategy<AuditDatasetType> getClientAuditStrategy() {
        return this.transactionConfiguration.getClientAuditStrategy();
    }

    @Override
    public AuditStrategy<AuditDatasetType> getServerAuditStrategy() {
        return this.transactionConfiguration.getServerAuditStrategy();
    }

    public NakFactory getNakFactory() {
        return new NakFactory(this.transactionConfiguration);
    }

    public void setTransactionConfiguration(Hl7v2TransactionConfiguration transactionConfiguration) {
        this.transactionConfiguration = transactionConfiguration;
    }
}

