/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.core.payload.ExpressionResolver;
import org.openehealth.ipf.commons.ihe.core.payload.SpringExpressionResolver;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorFactorySupport;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.MllpPayloadLoggerBase;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerStringProcessingInterceptor;

public class ConsumerInPayloadLoggerInterceptor
extends InterceptorSupport<MllpEndpoint<?, ?>> {
    private final MllpPayloadLoggerBase base = new MllpPayloadLoggerBase();

    public ConsumerInPayloadLoggerInterceptor(String fileNamePattern) {
        this((ExpressionResolver)new SpringExpressionResolver(fileNamePattern));
    }

    public ConsumerInPayloadLoggerInterceptor(ExpressionResolver resolver) {
        this.addBefore(new String[]{ConsumerStringProcessingInterceptor.class.getName()});
        this.setExpressionResolver(resolver);
    }

    public void process(Exchange exchange) throws Exception {
        if (this.canProcess()) {
            this.logPayload(exchange, false);
        }
        this.getWrappedProcessor().process(exchange);
    }

    public void logPayload(Exchange exchange, boolean useOutMessage) {
        this.base.logPayload(exchange, useOutMessage);
    }

    public boolean canProcess() {
        return this.base.canProcess();
    }

    public int getErrorCountLimit() {
        return this.base.getErrorCountLimit();
    }

    public ExpressionResolver getExpressionResolver() {
        return this.base.getExpressionResolver();
    }

    public boolean isEnabled() {
        return this.base.isEnabled();
    }

    @Deprecated
    public boolean isLocallyEnabled() {
        return this.base.isLocallyEnabled();
    }

    public void resetErrorCount() {
        this.base.resetErrorCount();
    }

    public void setEnabled(boolean arg0) {
        this.base.setEnabled(arg0);
    }

    public void setErrorCountLimit(int arg0) {
        this.base.setErrorCountLimit(arg0);
    }

    public void setExpressionResolver(ExpressionResolver arg0) {
        this.base.setExpressionResolver(arg0);
    }

    @Deprecated
    public void setLocallyEnabled(boolean arg0) {
        this.base.setLocallyEnabled(arg0);
    }

    public static class Factory
    extends InterceptorFactorySupport<MllpEndpoint<?, ?>, ConsumerInPayloadLoggerInterceptor> {
        private final ExpressionResolver resolver;
        private boolean locallyEnabled = true;

        public Factory(String fileNamePattern) {
            this((ExpressionResolver)new SpringExpressionResolver(fileNamePattern));
        }

        public Factory(ExpressionResolver resolver) {
            super(ConsumerInPayloadLoggerInterceptor.class);
            this.resolver = resolver;
        }

        public ConsumerInPayloadLoggerInterceptor getNewInstance() {
            ConsumerInPayloadLoggerInterceptor interceptor = new ConsumerInPayloadLoggerInterceptor(this.resolver);
            interceptor.setLocallyEnabled(this.locallyEnabled);
            return interceptor;
        }

        public void setLocallyEnabled(boolean locallyEnabled) {
            this.locallyEnabled = locallyEnabled;
        }
    }
}

