/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti31;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.PAM;
import org.openehealth.ipf.commons.ihe.hl7v2.TransactionOptionUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.TransactionOptions;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.iti31.Iti31AuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti31.Iti31Options;

public class Iti31Component
extends MllpTransactionComponent<Iti31AuditDataset> {
    public Iti31Component() {
        super((Hl7v2InteractionId)PAM.Interactions.ITI_31);
    }

    public Iti31Component(CamelContext camelContext) {
        super(camelContext, (Hl7v2InteractionId)PAM.Interactions.ITI_31);
    }

    @Override
    protected MllpTransactionEndpointConfiguration createConfig(String uri, Map<String, Object> parameters) throws Exception {
        MllpEndpointConfiguration config = super.createConfig(uri, (Map)parameters);
        String options = (String)this.getAndRemoveParameter(parameters, "options", String.class, Iti31Options.BASIC.name());
        TransactionOptions[] iti31Options = (Iti31Options[])TransactionOptionUtils.split((String)options, Iti31Options.class);
        if (iti31Options == null) {
            throw new IllegalArgumentException("Options parameter for pam-iti30 is invalid");
        }
        this.getInteractionId().init(iti31Options);
        return config;
    }
}

