/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import java.net.InetSocketAddress;
import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.MllpAuditUtils;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuthenticationFailure;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;

public class ConsumerAuthenticationFailureInterceptor
extends InterceptorSupport<MllpTransactionEndpoint<?>> {
    public void process(Exchange exchange) throws Exception {
        try {
            this.getWrappedProcessor().process(exchange);
        }
        catch (MllpAuthenticationFailure e) {
            MllpAuditUtils.auditAuthenticationNodeFailure((String)this.getRemoteAddress(exchange));
            throw e;
        }
    }

    private String getRemoteAddress(Exchange exchange) {
        InetSocketAddress address = (InetSocketAddress)exchange.getIn().getHeader("CamelMina2RemoteAddress");
        return address != null ? address.getAddress().getHostAddress() : "unknown";
    }
}

