/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.AuditUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.MllpAuditDataset;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.atna.interceptor.AuditInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditInterceptorUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuditInterceptorUtils.class);

    private AuditInterceptorUtils() {
        throw new IllegalStateException("Helper class");
    }

    public static <AuditDatasetType extends MllpAuditDataset> void doProcess(AuditInterceptor<AuditDatasetType, MllpTransactionEndpoint<AuditDatasetType>> interceptor, Exchange exchange) throws Exception {
        Message msg = (Message)exchange.getIn().getBody(Message.class);
        if (!AuditInterceptorUtils.isAuditable(interceptor, msg)) {
            interceptor.getWrappedProcessor().process(exchange);
            return;
        }
        AuditStrategy strategy = interceptor.getAuditStrategy();
        Object auditDataset = AuditInterceptorUtils.createAndEnrichAuditDatasetFromRequest(strategy, exchange, msg);
        AuditInterceptorUtils.determineParticipantsAddresses(interceptor, exchange, auditDataset);
        boolean failed = false;
        try {
            try {
                interceptor.getWrappedProcessor().process(exchange);
                Message result = (Message)Exchanges.resultMessage((Exchange)exchange).getBody(Message.class);
                AuditInterceptorUtils.enrichAuditDatasetFromResponse(strategy, auditDataset, result);
                failed = !AuditUtils.isPositiveAck((Message)result);
            }
            catch (Exception e) {
                failed = true;
                throw e;
            }
        }
        finally {
            AuditUtils.finalizeAudit(auditDataset, (AuditStrategy)strategy, (boolean)failed);
        }
    }

    private static <AuditDatasetType extends MllpAuditDataset> boolean isAuditable(AuditInterceptor<AuditDatasetType, MllpTransactionEndpoint<AuditDatasetType>> interceptor, Message message) {
        block3: {
            try {
                Terser terser = new Terser(message);
                if (!ArrayUtils.contains((Object[])message.getNames(), (Object)"DSC") || !StringUtils.isNotEmpty((CharSequence)terser.get("DSC-1"))) break block3;
                return false;
            }
            catch (Exception e) {
                LOG.error("Exception when determining message auditability, no audit will be performed", (Throwable)e);
                return false;
            }
        }
        return ((MllpTransactionEndpoint)interceptor.getEndpoint()).getHl7v2TransactionConfiguration().isAuditable(MessageUtils.eventType((Message)message));
    }

    private static <T extends MllpAuditDataset> T createAndEnrichAuditDatasetFromRequest(AuditStrategy<T> strategy, Exchange exchange, Message msg) {
        try {
            MllpAuditDataset auditDataset = (MllpAuditDataset)strategy.createAuditDataset();
            AuditUtils.enrichGenericAuditDatasetFromRequest((MllpAuditDataset)auditDataset, (Message)msg);
            return (T)((MllpAuditDataset)strategy.enrichAuditDatasetFromRequest((AuditDataset)auditDataset, (Object)msg, exchange.getIn().getHeaders()));
        }
        catch (Exception e) {
            LOG.error("Exception when enriching audit dataset from request", (Throwable)e);
            return null;
        }
    }

    private static <AuditDatasetType extends MllpAuditDataset> void enrichAuditDatasetFromResponse(AuditStrategy<AuditDatasetType> strategy, AuditDatasetType auditDataset, Message msg) {
        try {
            strategy.enrichAuditDatasetFromResponse(auditDataset, (Object)msg);
        }
        catch (Exception e) {
            LOG.error("Exception when enriching audit dataset from response", (Throwable)e);
        }
    }

    private static <AuditDatasetType extends MllpAuditDataset> void determineParticipantsAddresses(AuditInterceptor<AuditDatasetType, MllpTransactionEndpoint<AuditDatasetType>> interceptor, Exchange exchange, AuditDatasetType auditDataset) {
        try {
            interceptor.determineParticipantsAddresses(exchange, auditDataset);
        }
        catch (Exception e) {
            LOG.error("Exception when determining participants' addresses", (Throwable)e);
        }
    }
}

