/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.hl7v2.storage.UnsolicitedFragmentationStorage;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.FragmentationUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerRequestDefragmenterInterceptor
extends InterceptorSupport<MllpTransactionEndpoint<?>> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConsumerRequestDefragmenterInterceptor.class);
    private UnsolicitedFragmentationStorage storage;

    public void setEndpoint(MllpTransactionEndpoint<?> endpoint) {
        super.setEndpoint(endpoint);
        this.storage = ((MllpTransactionEndpoint)this.getEndpoint()).getUnsolicitedFragmentationStorage();
        Validate.notNull((Object)this.storage);
    }

    public void process(Exchange exchange) throws Exception {
        StringBuilder accumulator;
        String requestString = (String)exchange.getIn().getBody(String.class);
        Parser parser = ((MllpTransactionEndpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().getParser();
        Message requestMessage = parser.parse(requestString);
        Terser requestTerser = new Terser(requestMessage);
        String msh14 = requestTerser.get("MSH-14");
        String dsc1 = null;
        try {
            if (!"I".equals(requestTerser.get("DSC-2"))) {
                dsc1 = requestTerser.get("DSC-1");
            }
        }
        catch (HL7Exception hL7Exception) {}
        if (StringUtils.isEmpty((CharSequence)msh14) && StringUtils.isEmpty(dsc1)) {
            this.getWrappedProcessor().process(exchange);
            return;
        }
        String msh31 = requestTerser.get("MSH-3-1");
        String msh32 = requestTerser.get("MSH-3-2");
        String msh33 = requestTerser.get("MSH-3-3");
        if (StringUtils.isEmpty((CharSequence)msh14)) {
            accumulator = new StringBuilder();
        } else {
            accumulator = this.storage.getAndRemove(FragmentationUtils.keyString(msh14, msh31, msh32, msh33));
            if (accumulator == null) {
                LOG.warn("Pass unknown fragment with MSH-14=={} to the route", (Object)msh14);
                this.getWrappedProcessor().process(exchange);
                return;
            }
        }
        int beginIndex = StringUtils.isEmpty((CharSequence)msh14) ? 0 : requestString.indexOf(13);
        int endIndex = StringUtils.isEmpty((CharSequence)dsc1) ? requestString.length() : requestString.indexOf("\rDSC") + 1;
        accumulator.append(requestString, beginIndex, endIndex);
        if (StringUtils.isEmpty((CharSequence)dsc1)) {
            LOG.debug("Finished fragment chain {}", (Object)msh14);
            exchange.getIn().setBody((Object)accumulator.toString());
            this.getWrappedProcessor().process(exchange);
            return;
        }
        LOG.debug("Processed fragment {} requesting {}", (Object)msh14, (Object)dsc1);
        this.storage.put(FragmentationUtils.keyString(dsc1, msh31, msh32, msh33), accumulator);
        Message ack = MessageUtils.response((Message)requestMessage, (String)"ACK", (String)requestTerser.get("MSH-9-2"));
        Terser ackTerser = new Terser(ack);
        ackTerser.set("MSA-1", "CA");
        ackTerser.set("MSA-2", requestTerser.get("MSH-10"));
        Exchanges.resultMessage((Exchange)exchange).setBody((Object)parser.encode(ack));
    }
}

