/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.storage.InteractiveContinuationStorage;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.FragmentationUtils;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerInteractiveResponseSenderInterceptor
extends InterceptorSupport<MllpTransactionEndpoint<?>> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConsumerInteractiveResponseSenderInterceptor.class);
    private InteractiveContinuationStorage storage;

    public void setEndpoint(MllpTransactionEndpoint<?> endpoint) {
        super.setEndpoint(endpoint);
        this.storage = (InteractiveContinuationStorage)Validate.notNull((Object)((MllpTransactionEndpoint)this.getEndpoint()).getInteractiveContinuationStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Parser parser = ((MllpTransactionEndpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().getParser();
        Message requestMessage = (Message)exchange.getIn().getHeader("ipf.hl7v2.OriginalMessageAdapter", Message.class);
        Terser requestTerser = new Terser(requestMessage);
        String requestMessageType = requestTerser.get("MSH-9-1");
        String msh31 = requestTerser.get("MSH-3-1");
        String msh32 = requestTerser.get("MSH-3-2");
        String msh33 = requestTerser.get("MSH-3-3");
        if ("QCN".equals(requestMessageType) || "CNQ".equals(requestTerser.get("MSH-9-2"))) {
            String queryTag;
            String string = queryTag = "QCN".equals(requestMessageType) ? requestTerser.get("QID-1") : requestTerser.get("QPD-2");
            if (this.storage.delete(FragmentationUtils.keyString(queryTag, msh31, msh32, msh33))) {
                LOG.debug("Dropped response chain for query tag {}", (Object)queryTag);
                Message ack = requestMessage.generateACK();
                Terser.set((Segment)((Segment)ack.get("MSH")), (int)9, (int)0, (int)3, (int)1, (String)"ACK");
                Exchanges.resultMessage((Exchange)exchange).setBody((Object)parser.encode(ack));
            } else {
                this.getWrappedProcessor().process(exchange);
            }
            return;
        }
        if (!((MllpTransactionEndpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().isContinuable(requestMessageType)) {
            this.getWrappedProcessor().process(exchange);
            return;
        }
        String rcp22 = requestTerser.get("RCP-2-2");
        if (!"RD".equals(rcp22)) {
            if (rcp22 != null) {
                LOG.warn("Unit '{}' in RCP-2-2 is not supported", (Object)rcp22);
            }
            this.getWrappedProcessor().process(exchange);
            return;
        }
        int threshold = -1;
        try {
            threshold = Integer.parseInt(requestTerser.get("RCP-2-1"));
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Cannot parse RCP-2-1, try to use default threshold", (Throwable)nfe);
        }
        if (threshold < 1) {
            threshold = ((MllpTransactionEndpoint)this.getEndpoint()).getInteractiveContinuationDefaultThreshold();
        }
        if (threshold < 1) {
            LOG.debug("Cannot perform interactive continuation: invalid or missing threshold");
            this.getWrappedProcessor().process(exchange);
            return;
        }
        String continuationPointer = requestTerser.get("DSC-1");
        if (StringUtils.isEmpty((CharSequence)continuationPointer)) {
            continuationPointer = null;
        }
        if (continuationPointer != null && !"I".equals(requestTerser.get("DSC-2"))) {
            LOG.warn("Cannot perform interactive continuation: DSC-1 is not empty and DSC-2 is not 'I'");
            this.getWrappedProcessor().process(exchange);
            return;
        }
        String queryTag = requestTerser.get("QPD-2");
        if (StringUtils.isEmpty((CharSequence)queryTag)) {
            LOG.warn("Cannot perform interactive continuation: empty query tag in QPD-2");
            this.getWrappedProcessor().process(exchange);
            return;
        }
        String chainId = FragmentationUtils.keyString(queryTag, msh31, msh32, msh33);
        Message responseMessage = this.storage.get(continuationPointer, chainId);
        if (responseMessage != null) {
            LOG.debug("Use prepared fragment for {}", (Object)continuationPointer);
            Message message = responseMessage;
            synchronized (message) {
                Terser responseTerser = new Terser(responseMessage);
                responseTerser.set("MSH-7", MessageUtils.hl7Now());
                responseTerser.set("MSH-10", FragmentationUtils.uniqueId());
                responseTerser.set("MSA-2", requestTerser.get("MSH-10"));
            }
        } else {
            this.getWrappedProcessor().process(exchange);
            Message response = (Message)Exchanges.resultMessage((Exchange)exchange).getBody(Message.class);
            responseMessage = this.considerFragmentingResponse(response, threshold, queryTag, chainId);
        }
        Exchanges.resultMessage((Exchange)exchange).setBody((Object)parser.encode(responseMessage));
    }

    private Message considerFragmentingResponse(Message responseMessage, int threshold, String queryTag, String chainId) throws Exception {
        Terser responseTerser = new Terser(responseMessage);
        if (StringUtils.isNotEmpty((CharSequence)responseTerser.get("DSC-1"))) {
            LOG.warn("Cannot perform interactive continuation: DSC-1 already present in the response message returned from the route");
            return responseMessage;
        }
        List<String> segments = FragmentationUtils.splitString(responseMessage.toString(), '\r');
        List<Integer> recordBoundaries = this.getRecordBoundaries(segments);
        if (recordBoundaries.size() - 1 <= threshold) {
            return responseMessage;
        }
        CharSequence headerSegments = FragmentationUtils.joinSegments(segments, 0, recordBoundaries.get(0));
        CharSequence footerSegments = FragmentationUtils.joinSegments(segments, recordBoundaries.get(recordBoundaries.size() - 1), segments.size());
        int fragmentsCount = (recordBoundaries.size() + threshold - 2) / threshold;
        Parser parser = ((MllpTransactionEndpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().getParser();
        String continuationPointer = null;
        int currentFragmentIndex = 0;
        while (currentFragmentIndex < fragmentsCount) {
            int startRecordIndex = currentFragmentIndex * threshold;
            int endRecordIndex = Math.min(startRecordIndex + threshold, recordBoundaries.size() - 1);
            int startSegmentIndex = recordBoundaries.get(startRecordIndex);
            int endSegmentIndex = recordBoundaries.get(endRecordIndex);
            StringBuilder sb = new StringBuilder(headerSegments);
            FragmentationUtils.appendSegments(sb, segments, startSegmentIndex, endSegmentIndex);
            sb.append(footerSegments);
            Message fragment = parser.parse(sb.toString());
            Terser fragmentTerser = new Terser(fragment);
            String nextContinuationPointer = FragmentationUtils.uniqueId();
            if (currentFragmentIndex != fragmentsCount - 1) {
                fragmentTerser.set("DSC-1", nextContinuationPointer);
                fragmentTerser.set("DSC-2", "I");
            }
            fragmentTerser.set("QAK-4", Integer.toString(recordBoundaries.size() - 1));
            fragmentTerser.set("QAK-5", Integer.toString(endRecordIndex - startRecordIndex));
            fragmentTerser.set("QAK-6", Integer.toString(recordBoundaries.size() - 1 - endRecordIndex));
            this.storage.put(continuationPointer, chainId, fragment);
            continuationPointer = nextContinuationPointer;
            if (currentFragmentIndex == 0) {
                responseMessage = fragment;
            }
            ++currentFragmentIndex;
        }
        LOG.debug("Prepared {} interactive fragments for query tag {}", (Object)fragmentsCount, (Object)queryTag);
        return responseMessage;
    }

    private List<Integer> getRecordBoundaries(List<String> segments) {
        Hl7v2TransactionConfiguration config = ((MllpTransactionEndpoint)this.getEndpoint()).getHl7v2TransactionConfiguration();
        ArrayList<Integer> recordBoundaries = new ArrayList<Integer>();
        boolean foundFooter = false;
        int i = 1;
        while (i < segments.size()) {
            if (config.isDataStartSegment(segments, i)) {
                recordBoundaries.add(i);
            } else if (recordBoundaries.size() > 0 && config.isFooterStartSegment(segments, i)) {
                foundFooter = true;
                recordBoundaries.add(i);
                break;
            }
            ++i;
        }
        if (!foundFooter) {
            recordBoundaries.add(segments.size());
        }
        return recordBoundaries;
    }
}

