/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti30;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.PAM;
import org.openehealth.ipf.commons.ihe.hl7v2.TransactionOptionUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.TransactionOptions;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.iti30.Iti30AuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti30.Iti30Options;

public class Iti30Component
extends MllpTransactionComponent<Iti30AuditDataset> {
    public Iti30Component() {
        super((Hl7v2InteractionId)PAM.Interactions.ITI_30);
    }

    public Iti30Component(CamelContext camelContext) {
        super(camelContext, (Hl7v2InteractionId)PAM.Interactions.ITI_30);
    }

    @Override
    protected MllpTransactionEndpointConfiguration createConfig(String uri, Map<String, Object> parameters) throws Exception {
        MllpEndpointConfiguration config = super.createConfig(uri, (Map)parameters);
        String options = (String)this.getAndRemoveParameter(parameters, "options", String.class, Iti30Options.MERGE.name());
        TransactionOptions[] iti30Options = (Iti30Options[])TransactionOptionUtils.split((String)options, Iti30Options.class);
        if (iti30Options == null) {
            throw new IllegalArgumentException("Options parameter for pam-iti30 is invalid");
        }
        this.getInteractionId().init(iti30Options);
        return config;
    }
}

