/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.custom;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;

public class CustomMllpComponent<AuditDatasetType extends MllpAuditDataset>
extends MllpTransactionComponent<AuditDatasetType> {
    private Hl7v2TransactionConfiguration configuration;
    private AuditStrategy<AuditDatasetType> clientAuditStrategy;
    private AuditStrategy<AuditDatasetType> serverAuditStrategy;

    public CustomMllpComponent() {
        super((Hl7v2InteractionId)null);
    }

    public CustomMllpComponent(CamelContext camelContext) {
        super(camelContext, null);
    }

    @Override
    protected MllpTransactionEndpointConfiguration createConfig(String uri, Map<String, Object> parameters) throws Exception {
        MllpEndpointConfiguration transactionConfig = super.createConfig(uri, (Map)parameters);
        this.configuration = (Hl7v2TransactionConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "hl7TransactionConfig", Hl7v2TransactionConfiguration.class);
        if (this.configuration == null) {
            throw new IllegalArgumentException("Must provide hl7TransactionConfig attribute with custom MLLP component");
        }
        this.clientAuditStrategy = (AuditStrategy)this.resolveAndRemoveReferenceParameter(parameters, "clientAuditStrategy", AuditStrategy.class);
        if (transactionConfig.isAudit() && this.clientAuditStrategy == null) {
            throw new IllegalArgumentException("Consumer or Producer require ATNA audit, but no clientAuditStrategy is defined for custom MLLP component");
        }
        this.serverAuditStrategy = (AuditStrategy)this.resolveAndRemoveReferenceParameter(parameters, "serverAuditStrategy", AuditStrategy.class);
        if (transactionConfig.isAudit() && this.serverAuditStrategy == null) {
            throw new IllegalArgumentException("Consumer or Producer require ATNA audit, but no serverAuditStrategy is defined for custom MLLP component");
        }
        return transactionConfig;
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return this.configuration;
    }

    public NakFactory getNakFactory() {
        return new NakFactory(this.configuration);
    }

    @Override
    public AuditStrategy<AuditDatasetType> getClientAuditStrategy() {
        return this.clientAuditStrategy;
    }

    @Override
    public AuditStrategy<AuditDatasetType> getServerAuditStrategy() {
        return this.serverAuditStrategy;
    }
}

