/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti31;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.core.TransactionOptionUtils;
import org.openehealth.ipf.commons.ihe.core.TransactionOptions;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.iti31.Iti31AuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.iti31.Iti31ClientAuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.iti31.Iti31ServerAuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.CustomModelClassUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pam.PamTransactions;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti31.Iti31Options;

public class Iti31Component
extends MllpTransactionComponent<Iti31AuditDataset> {
    private static final AuditStrategy<Iti31AuditDataset> CLIENT_AUDIT_STRATEGY = new Iti31ClientAuditStrategy();
    private static final AuditStrategy<Iti31AuditDataset> SERVER_AUDIT_STRATEGY = new Iti31ServerAuditStrategy();
    private Hl7v2TransactionConfiguration hl7v2TransactionConfiguration;
    private NakFactory nakFactory;

    public Iti31Component() {
    }

    public Iti31Component(CamelContext camelContext) {
        super(camelContext);
    }

    public AuditStrategy<Iti31AuditDataset> getClientAuditStrategy() {
        return CLIENT_AUDIT_STRATEGY;
    }

    public AuditStrategy<Iti31AuditDataset> getServerAuditStrategy() {
        return SERVER_AUDIT_STRATEGY;
    }

    @Override
    protected MllpTransactionEndpointConfiguration createConfig(Map<String, Object> parameters) throws Exception {
        MllpEndpointConfiguration config = super.createConfig((Map)parameters);
        String options = (String)this.getAndRemoveParameter(parameters, "options", String.class, Iti31Options.BASIC.name());
        Iti31Options[] iti31Options = (Iti31Options[])TransactionOptionUtils.split((String)options, Iti31Options.class);
        if (iti31Options == null) {
            throw new IllegalArgumentException("Options parameter for pam-iti30 is invalid");
        }
        this.initConfiguration(iti31Options);
        return config;
    }

    private void initConfiguration(Iti31Options ... options) {
        this.hl7v2TransactionConfiguration = new Hl7v2TransactionConfiguration(new Version[]{Version.V25}, "PEM adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"ADT"}, TransactionOptionUtils.concatAllToString((TransactionOptions[])options), new String[]{"ACK"}, new String[]{"*"}, new boolean[]{true}, new boolean[1], HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory((String)"pam", (String)"2.5"), (HL7v2Transactions)PamTransactions.ITI31));
        this.nakFactory = new NakFactory(this.hl7v2TransactionConfiguration);
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return this.hl7v2TransactionConfiguration;
    }

    public NakFactory getNakFactory() {
        return this.nakFactory;
    }
}

