/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.openehealth.ipf.commons.ihe.core.ClientAuthType;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptableEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerDispatchingInterceptor;

public class MllpEndpointConfiguration
extends InterceptableEndpointConfiguration {
    private static final long serialVersionUID = -3604219045768985192L;
    private final ProtocolCodecFactory codecFactory;
    private final boolean audit;
    private final SSLContext sslContext;
    private final ClientAuthType clientAuthType;
    private final String[] sslProtocols;
    private final String[] sslCiphers;
    private final boolean supportSegmentFragmentation;
    private final int segmentFragmentationThreshold;
    private ConsumerDispatchingInterceptor dispatcher;

    protected MllpEndpointConfiguration(MllpComponent<?> component, Map<String, Object> parameters) throws Exception {
        super(component, parameters);
        this.codecFactory = (ProtocolCodecFactory)component.getCamelContext().getRegistry().lookupByNameAndType(MllpEndpointConfiguration.extractBeanName((String)parameters.get("codec")), ProtocolCodecFactory.class);
        this.audit = (Boolean)component.getAndRemoveParameter(parameters, "audit", Boolean.TYPE, true);
        this.clientAuthType = (ClientAuthType)component.getAndRemoveParameter(parameters, "clientAuth", ClientAuthType.class, ClientAuthType.NONE);
        String sslProtocolsString = (String)component.getAndRemoveParameter(parameters, "sslProtocols", String.class, null);
        String sslCiphersString = (String)component.getAndRemoveParameter(parameters, "sslCiphers", String.class, null);
        this.sslProtocols = sslProtocolsString != null ? sslProtocolsString.split(",") : null;
        this.sslCiphers = sslCiphersString != null ? sslCiphersString.split(",") : null;
        boolean secure = (Boolean)component.getAndRemoveParameter(parameters, "secure", Boolean.TYPE, false);
        this.sslContext = secure ? (SSLContext)component.resolveAndRemoveReferenceParameter(parameters, "sslContext", SSLContext.class, SSLContext.getDefault()) : null;
        this.supportSegmentFragmentation = (Boolean)component.getAndRemoveParameter(parameters, "supportSegmentFragmentation", Boolean.TYPE, false);
        this.segmentFragmentationThreshold = (Integer)component.getAndRemoveParameter(parameters, "segmentFragmentationThreshold", Integer.TYPE, -1);
        this.dispatcher = (ConsumerDispatchingInterceptor)((Object)component.resolveAndRemoveReferenceParameter(parameters, "dispatcher", ConsumerDispatchingInterceptor.class));
    }

    private static String extractBeanName(String originalBeanName) {
        return originalBeanName.startsWith("#") ? originalBeanName.substring(1) : originalBeanName;
    }

    public ProtocolCodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public boolean isAudit() {
        return this.audit;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ClientAuthType getClientAuthType() {
        return this.clientAuthType;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    public boolean isSupportSegmentFragmentation() {
        return this.supportSegmentFragmentation;
    }

    public int getSegmentFragmentationThreshold() {
        return this.segmentFragmentationThreshold;
    }

    public ConsumerDispatchingInterceptor getDispatcher() {
        return this.dispatcher;
    }
}

