/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti30;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.core.TransactionOptionUtils;
import org.openehealth.ipf.commons.ihe.core.TransactionOptions;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.iti30.Iti30AuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.iti30.Iti30ClientAuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.iti30.Iti30ServerAuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pam.PamTransactions;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti30.Iti30Options;

public class Iti30Component
extends MllpTransactionComponent<Iti30AuditDataset> {
    private static final AuditStrategy<Iti30AuditDataset> CLIENT_AUDIT_STRATEGY = new Iti30ClientAuditStrategy();
    private static final AuditStrategy<Iti30AuditDataset> SERVER_AUDIT_STRATEGY = new Iti30ServerAuditStrategy();
    private Hl7v2TransactionConfiguration hl7v2TransactionConfiguration;
    private NakFactory nakFactory;

    public Iti30Component() {
    }

    public Iti30Component(CamelContext camelContext) {
        super(camelContext);
    }

    public AuditStrategy<Iti30AuditDataset> getClientAuditStrategy() {
        return CLIENT_AUDIT_STRATEGY;
    }

    public AuditStrategy<Iti30AuditDataset> getServerAuditStrategy() {
        return SERVER_AUDIT_STRATEGY;
    }

    @Override
    protected MllpTransactionEndpointConfiguration createConfig(Map<String, Object> parameters) throws Exception {
        MllpEndpointConfiguration config = super.createConfig((Map)parameters);
        String options = (String)this.getAndRemoveParameter(parameters, "options", String.class, Iti30Options.MERGE.name());
        Iti30Options[] iti30Options = (Iti30Options[])TransactionOptionUtils.split((String)options, Iti30Options.class);
        if (iti30Options == null) {
            throw new IllegalArgumentException("Options parameter for pam-iti30 is invalid");
        }
        this.initConfiguration(iti30Options);
        return config;
    }

    private void initConfiguration(Iti30Options ... options) {
        this.hl7v2TransactionConfiguration = new Hl7v2TransactionConfiguration(new Version[]{Version.V25}, "PIM adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"ADT"}, TransactionOptionUtils.concatAllToString((TransactionOptions[])options), new String[]{"ACK"}, new String[]{"*"}, new boolean[]{true}, new boolean[1], HapiContextFactory.createHapiContext((HL7v2Transactions)PamTransactions.ITI30));
        this.nakFactory = new NakFactory(this.hl7v2TransactionConfiguration);
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return this.hl7v2TransactionConfiguration;
    }

    public NakFactory getNakFactory() {
        return this.nakFactory;
    }
}

