/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import java.net.InetSocketAddress;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.atna.interceptor.AuditInterceptor;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.AuditInterceptorUtils;

public class ConsumerAuditInterceptor<AuditDatasetType extends MllpAuditDataset>
extends InterceptorSupport<MllpTransactionEndpoint<AuditDatasetType>>
implements AuditInterceptor<AuditDatasetType, MllpTransactionEndpoint<AuditDatasetType>> {
    public void process(Exchange exchange) throws Exception {
        AuditInterceptorUtils.doProcess(this, exchange);
    }

    public AuditStrategy<AuditDatasetType> getAuditStrategy() {
        return ((MllpTransactionEndpoint)this.getEndpoint()).getServerAuditStrategy();
    }

    public void determineParticipantsAddresses(Exchange exchange, MllpAuditDataset auditDataset) throws Exception {
        Message message = exchange.getIn();
        auditDataset.setLocalAddress(ConsumerAuditInterceptor.addressFromHeader(message, "CamelMina2LocalAddress"));
        auditDataset.setRemoteAddress(ConsumerAuditInterceptor.addressFromHeader(message, "CamelMina2RemoteAddress"));
    }

    private static String addressFromHeader(Message message, String headerName) {
        InetSocketAddress address = (InetSocketAddress)message.getHeader(headerName);
        return address.getAddress().getHostAddress();
    }
}

