/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.Map;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.InteractiveContinuationStorage;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.UnsolicitedFragmentationStorage;

public class MllpTransactionEndpointConfiguration
extends MllpEndpointConfiguration {
    private static final long serialVersionUID = -6154765290339153487L;
    private final boolean supportUnsolicitedFragmentation;
    private final int unsolicitedFragmentationThreshold;
    private final UnsolicitedFragmentationStorage unsolicitedFragmentationStorage;
    private final boolean supportInteractiveContinuation;
    private final int interactiveContinuationDefaultThreshold;
    private final InteractiveContinuationStorage interactiveContinuationStorage;
    private final boolean autoCancel;

    protected MllpTransactionEndpointConfiguration(MllpComponent<MllpTransactionEndpointConfiguration> component, Map<String, Object> parameters) throws Exception {
        super(component, parameters);
        this.supportUnsolicitedFragmentation = (Boolean)component.getAndRemoveParameter(parameters, "supportUnsolicitedFragmentation", Boolean.TYPE, false);
        this.unsolicitedFragmentationThreshold = (Integer)component.getAndRemoveParameter(parameters, "unsolicitedFragmentationThreshold", Integer.TYPE, -1);
        this.unsolicitedFragmentationStorage = (UnsolicitedFragmentationStorage)component.resolveAndRemoveReferenceParameter(parameters, "unsolicitedFragmentationStorage", UnsolicitedFragmentationStorage.class);
        this.supportInteractiveContinuation = (Boolean)component.getAndRemoveParameter(parameters, "supportInteractiveContinuation", Boolean.TYPE, false);
        this.interactiveContinuationDefaultThreshold = (Integer)component.getAndRemoveParameter(parameters, "interactiveContinuationDefaultThreshold", Integer.TYPE, -1);
        this.interactiveContinuationStorage = (InteractiveContinuationStorage)component.resolveAndRemoveReferenceParameter(parameters, "interactiveContinuationStorage", InteractiveContinuationStorage.class);
        this.autoCancel = (Boolean)component.getAndRemoveParameter(parameters, "autoCancel", Boolean.TYPE, false);
    }

    public boolean isSupportUnsolicitedFragmentation() {
        return this.supportUnsolicitedFragmentation;
    }

    public int getUnsolicitedFragmentationThreshold() {
        return this.unsolicitedFragmentationThreshold;
    }

    public UnsolicitedFragmentationStorage getUnsolicitedFragmentationStorage() {
        return this.unsolicitedFragmentationStorage;
    }

    public boolean isSupportInteractiveContinuation() {
        return this.supportInteractiveContinuation;
    }

    public int getInteractiveContinuationDefaultThreshold() {
        return this.interactiveContinuationDefaultThreshold;
    }

    public InteractiveContinuationStorage getInteractiveContinuationStorage() {
        return this.interactiveContinuationStorage;
    }

    public boolean isAutoCancel() {
        return this.autoCancel;
    }
}

