/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.hl7v2.atna.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.atna.AuditableEndpoint;
import org.openehealth.ipf.platform.camel.ihe.core.Interceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerAdaptingInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerMarshalInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerRequestAcceptanceInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerResponseAcceptanceInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerAdaptingInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerMarshalInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerRequestAcceptanceInterceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerResponseAcceptanceInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.InteractiveContinuationStorage;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.UnsolicitedFragmentationStorage;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerAuditInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerAuthenticationFailureInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerInteractiveResponseSenderInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerRequestDefragmenterInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerStringProcessingInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerAuditInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerMarshalAndInteractiveResponseReceiverInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerRequestFragmenterInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.producer.ProducerStringProcessingInterceptor;

public class MllpTransactionEndpoint<AuditDatasetType extends MllpAuditDataset>
extends MllpEndpoint<MllpTransactionEndpointConfiguration, MllpTransactionComponent<AuditDatasetType>>
implements AuditableEndpoint<AuditDatasetType> {
    public MllpTransactionEndpoint(MllpTransactionComponent<AuditDatasetType> mllpComponent, Mina2Endpoint wrappedEndpoint, MllpTransactionEndpointConfiguration config) {
        super(mllpComponent, wrappedEndpoint, config);
    }

    protected List<Interceptor> createInitialConsumerInterceptorChain() {
        ArrayList<Interceptor> initialChain = new ArrayList<Interceptor>();
        initialChain.add((Interceptor)new ConsumerStringProcessingInterceptor());
        if (this.isSupportUnsolicitedFragmentation()) {
            initialChain.add((Interceptor)new ConsumerRequestDefragmenterInterceptor());
        }
        initialChain.add((Interceptor)new ConsumerMarshalInterceptor());
        initialChain.add((Interceptor)new ConsumerRequestAcceptanceInterceptor());
        if (this.isSupportInteractiveContinuation()) {
            initialChain.add((Interceptor)new ConsumerInteractiveResponseSenderInterceptor());
        }
        if (this.isAudit()) {
            initialChain.add((Interceptor)new ConsumerAuditInterceptor());
        }
        initialChain.add((Interceptor)new ConsumerResponseAcceptanceInterceptor());
        initialChain.add((Interceptor)new ConsumerAdaptingInterceptor(this.getCharsetName()));
        if (this.isAudit()) {
            initialChain.add((Interceptor)new ConsumerAuthenticationFailureInterceptor());
        }
        return initialChain;
    }

    protected List<Interceptor> createInitialProducerInterceptorChain() {
        ArrayList<Interceptor> initialChain = new ArrayList<Interceptor>();
        initialChain.add((Interceptor)new ProducerStringProcessingInterceptor());
        if (this.isSupportUnsolicitedFragmentation()) {
            initialChain.add((Interceptor)new ProducerRequestFragmenterInterceptor());
        }
        initialChain.add((Interceptor)(this.isSupportInteractiveContinuation() ? new ProducerMarshalAndInteractiveResponseReceiverInterceptor() : new ProducerMarshalInterceptor()));
        initialChain.add((Interceptor)new ProducerResponseAcceptanceInterceptor());
        if (this.isAudit()) {
            initialChain.add((Interceptor)new ProducerAuditInterceptor());
        }
        initialChain.add((Interceptor)new ProducerRequestAcceptanceInterceptor());
        initialChain.add((Interceptor)new ProducerAdaptingInterceptor());
        return initialChain;
    }

    @ManagedAttribute(description="Audit Enabled")
    public boolean isAudit() {
        return ((MllpTransactionEndpointConfiguration)((Object)this.getConfig())).isAudit();
    }

    public AuditStrategy<AuditDatasetType> getClientAuditStrategy() {
        return ((MllpTransactionComponent)((Object)this.getMllpComponent())).getClientAuditStrategy();
    }

    public AuditStrategy<AuditDatasetType> getServerAuditStrategy() {
        return ((MllpTransactionComponent)((Object)this.getMllpComponent())).getServerAuditStrategy();
    }

    @ManagedAttribute(description="Support Unsolicited Fragmentation Enabled")
    public boolean isSupportUnsolicitedFragmentation() {
        return ((MllpTransactionEndpointConfiguration)((Object)this.getConfig())).isSupportUnsolicitedFragmentation();
    }

    @ManagedAttribute(description="Unsolicited Fragmentation Threshold")
    public int getUnsolicitedFragmentationThreshold() {
        return ((MllpTransactionEndpointConfiguration)((Object)this.getConfig())).getUnsolicitedFragmentationThreshold();
    }

    public UnsolicitedFragmentationStorage getUnsolicitedFragmentationStorage() {
        return ((MllpTransactionEndpointConfiguration)((Object)this.getConfig())).getUnsolicitedFragmentationStorage();
    }

    @ManagedAttribute(description="Unsolicited Fragmentation Storage Cache Type")
    public String getUnsolicitedFragmentationStorageType() {
        return this.isSupportUnsolicitedFragmentation() ? this.getUnsolicitedFragmentationStorage().getClass().getName() : "";
    }

    @ManagedAttribute(description="Support Interactive Continuation Enabled")
    public boolean isSupportInteractiveContinuation() {
        return ((MllpTransactionEndpointConfiguration)((Object)this.getConfig())).isSupportInteractiveContinuation();
    }

    @ManagedAttribute(description="Interactive Continuation Default Threshold")
    public int getInteractiveContinuationDefaultThreshold() {
        return ((MllpTransactionEndpointConfiguration)((Object)this.getConfig())).getInteractiveContinuationDefaultThreshold();
    }

    public InteractiveContinuationStorage getInteractiveContinuationStorage() {
        return ((MllpTransactionEndpointConfiguration)((Object)this.getConfig())).getInteractiveContinuationStorage();
    }

    @ManagedAttribute(description="Auto Cancel Enabled")
    public boolean isAutoCancel() {
        return ((MllpTransactionEndpointConfiguration)((Object)this.getConfig())).isAutoCancel();
    }

    @ManagedAttribute(description="Interactive Continuation Storage Cache Type")
    public String getInteractiveContinuationStorageType() {
        return this.isSupportInteractiveContinuation() ? this.getInteractiveContinuationStorage().getClass().getName() : "";
    }
}

