/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core;

import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.mina2.Mina2Consumer;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.apache.camel.component.mina2.Mina2Helper;
import org.apache.camel.component.mina2.Mina2PayloadHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MllpExceptionIoFilter
extends IoFilterAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MllpExceptionIoFilter.class);
    private final Mina2Consumer mina2Consumer;

    public MllpExceptionIoFilter(Mina2Consumer mina2Consumer) {
        this.mina2Consumer = mina2Consumer;
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        Exchange exchange = this.mina2Consumer.getEndpoint().createExchange();
        CamelException exception = new CamelException(cause.getMessage());
        exchange.setException((Throwable)exception);
        this.mina2Consumer.getExceptionHandler().handleException("", exchange, (Throwable)exception);
        this.sendResponse(session, exchange);
    }

    private void sendResponse(IoSession session, Exchange exchange) throws Exception {
        Object response;
        boolean disconnect = this.mina2Consumer.getEndpoint().getConfiguration().isDisconnect();
        Object object = response = exchange.hasOut() ? Mina2PayloadHelper.getOut((Mina2Endpoint)this.mina2Consumer.getEndpoint(), (Exchange)exchange) : Mina2PayloadHelper.getIn((Mina2Endpoint)this.mina2Consumer.getEndpoint(), (Exchange)exchange);
        if (response != null) {
            LOG.debug("Writing body: {}", response);
            Mina2Helper.writeBody((IoSession)session, (Object)response, (Exchange)exchange);
        } else {
            LOG.debug("Writing no response");
            disconnect = Boolean.TRUE;
        }
        Message message = ExchangeHelper.isOutCapable((Exchange)exchange) ? exchange.getOut() : exchange.getIn();
        Boolean close = (Boolean)message.getHeader("CamelMina2CloseSessionWhenComplete", Boolean.class);
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            LOG.debug("Closing session when complete at address: {}", (Object)this.mina2Consumer.getAcceptor().getLocalAddress());
            session.close(true);
        }
    }
}

