/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti9;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.CustomModelClassUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pixpdq.PixPdqTransactions;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2Interceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerSegmentEchoingInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.QpdAwareNakFactory;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.QueryAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti9.Iti9ClientAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti9.Iti9ServerAuditStrategy;

public class Iti9Component
extends MllpTransactionComponent<QueryAuditDataset> {
    public static final Hl7v2TransactionConfiguration CONFIGURATION = new Hl7v2TransactionConfiguration(new Version[]{Version.V25}, "PIX adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"QBP"}, new String[]{"Q23"}, new String[]{"RSP"}, new String[]{"K23"}, new boolean[]{true}, new boolean[1], HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory((String)"pix", (String)"2.5"), (HL7v2Transactions)PixPdqTransactions.ITI9));
    private static final MllpAuditStrategy<QueryAuditDataset> CLIENT_AUDIT_STRATEGY = new Iti9ClientAuditStrategy();
    private static final MllpAuditStrategy<QueryAuditDataset> SERVER_AUDIT_STRATEGY = new Iti9ServerAuditStrategy();
    private static final NakFactory NAK_FACTORY = new QpdAwareNakFactory(CONFIGURATION, "RSP", "K23");

    public Iti9Component() {
    }

    public Iti9Component(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public MllpAuditStrategy<QueryAuditDataset> getClientAuditStrategy() {
        return CLIENT_AUDIT_STRATEGY;
    }

    @Override
    public MllpAuditStrategy<QueryAuditDataset> getServerAuditStrategy() {
        return SERVER_AUDIT_STRATEGY;
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return CONFIGURATION;
    }

    public NakFactory getNakFactory() {
        return NAK_FACTORY;
    }

    @Override
    public List<Hl7v2Interceptor> getAdditionalConsumerInterceptors() {
        return Collections.singletonList(new ConsumerSegmentEchoingInterceptor("QPD"));
    }
}

