/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti8;

import ca.uhn.hl7v2.model.Message;
import org.apache.camel.Exchange;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti8.Iti8AuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti8.Iti8AuditStrategyUtils;
import org.openhealthtools.ihe.atna.auditor.codes.rfc3881.RFC3881EventCodes;

public abstract class Iti8AuditStrategy
extends MllpAuditStrategy<Iti8AuditDataset> {
    public Iti8AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    @Override
    public void enrichAuditDatasetFromRequest(Iti8AuditDataset auditDataset, Message msg, Exchange exchange) {
        Iti8AuditStrategyUtils.enrichAuditDatasetFromRequest(auditDataset, msg, exchange);
    }

    @Override
    public void doAudit(RFC3881EventCodes.RFC3881EventOutcomeCodes eventOutcome, Iti8AuditDataset auditDataset) {
        if ("A08".equals(auditDataset.getMessageType())) {
            this.callUpdateAuditRoutine(eventOutcome, auditDataset, true);
        } else if ("A40".equals(auditDataset.getMessageType())) {
            this.callDeleteAuditRoutine(eventOutcome, auditDataset, false);
            this.callUpdateAuditRoutine(eventOutcome, auditDataset, true);
        } else {
            this.callCreateAuditRoutine(eventOutcome, auditDataset, true);
        }
    }

    protected abstract void callCreateAuditRoutine(RFC3881EventCodes.RFC3881EventOutcomeCodes var1, Iti8AuditDataset var2, boolean var3);

    protected abstract void callUpdateAuditRoutine(RFC3881EventCodes.RFC3881EventOutcomeCodes var1, Iti8AuditDataset var2, boolean var3);

    protected abstract void callDeleteAuditRoutine(RFC3881EventCodes.RFC3881EventOutcomeCodes var1, Iti8AuditDataset var2, boolean var3);

    @Override
    public Iti8AuditDataset createAuditDataset() {
        return new Iti8AuditDataset(this.isServerSide());
    }
}

