/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti64;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.group.ADT_A43_PATIENT;
import ca.uhn.hl7v2.model.v25.message.ADT_A43;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.core.atna.AuditorManager;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti64.Iti64AuditDataset;
import org.openhealthtools.ihe.atna.auditor.codes.rfc3881.RFC3881EventCodes;

class Iti64AuditStrategy
extends MllpAuditStrategy<Iti64AuditDataset> {
    private static final EncodingCharacters ENCODING_CHARACTERS = new EncodingCharacters('|', '^', '~', '\\', '&');

    public Iti64AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    @Override
    public void enrichAuditDatasetFromRequest(Iti64AuditDataset auditDataset, Message msg, Exchange exchange) {
        ADT_A43 message = (ADT_A43)msg;
        ADT_A43_PATIENT patient = message.getPATIENT(0);
        auditDataset.setNewPatientId(PipeParser.encode((Type)patient.getPID().getPatientIdentifierList(0), (EncodingCharacters)ENCODING_CHARACTERS));
        auditDataset.setSourcePatientId(PipeParser.encode((Type)patient.getPID().getPatientIdentifierList(1), (EncodingCharacters)ENCODING_CHARACTERS));
        auditDataset.setOldPatientId(PipeParser.encode((Type)patient.getMRG().getMrg1_PriorPatientIdentifierList(0), (EncodingCharacters)ENCODING_CHARACTERS));
    }

    @Override
    public void doAudit(RFC3881EventCodes.RFC3881EventOutcomeCodes eventOutcome, Iti64AuditDataset auditDataset) {
        AuditorManager.getCustomPixAuditor().auditIti64(this.isServerSide(), eventOutcome, this.isServerSide() ? auditDataset.getRemoteAddress() : auditDataset.getLocalAddress(), auditDataset.getSendingFacility(), auditDataset.getSendingApplication(), this.isServerSide() ? auditDataset.getLocalAddress() : auditDataset.getRemoteAddress(), auditDataset.getReceivingFacility(), auditDataset.getReceivingApplication(), auditDataset.getMessageControlId(), auditDataset.getSourcePatientId(), auditDataset.getNewPatientId(), auditDataset.getOldPatientId());
    }

    @Override
    public Iti64AuditDataset createAuditDataset() {
        return new Iti64AuditDataset(this.isServerSide());
    }
}

