/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti22;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.CustomModelClassUtils;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pixpdq.PixPdqTransactions;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2Interceptor;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerSegmentEchoingInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.QpdAwareNakFactory;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.QueryAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti22.Iti22ClientAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti22.Iti22ServerAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.pdqcore.PdqTransactionConfiguration;

public class Iti22Component
extends MllpTransactionComponent<QueryAuditDataset> {
    public static final Hl7v2TransactionConfiguration CONFIGURATION;
    private static final MllpAuditStrategy<QueryAuditDataset> CLIENT_AUDIT_STRATEGY;
    private static final MllpAuditStrategy<QueryAuditDataset> SERVER_AUDIT_STRATEGY;
    private static final NakFactory NAK_FACTORY;

    static {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        CONFIGURATION = new PdqTransactionConfiguration(new Version[]{Version.V25}, "PDQ adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"QBP", "QCN"}, new String[]{"ZV1", "J01"}, new String[]{"RSP", "ACK"}, new String[]{"ZV2", "*"}, blArray, blArray2, HapiContextFactory.createHapiContext((ModelClassFactory)CustomModelClassUtils.createFactory((String)"pdq", (String)"2.5"), (HL7v2Transactions)PixPdqTransactions.ITI22));
        CLIENT_AUDIT_STRATEGY = new Iti22ClientAuditStrategy();
        SERVER_AUDIT_STRATEGY = new Iti22ServerAuditStrategy();
        NAK_FACTORY = new QpdAwareNakFactory(CONFIGURATION, "RSP", "ZV2");
    }

    public Iti22Component() {
    }

    public Iti22Component(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public MllpAuditStrategy<QueryAuditDataset> getClientAuditStrategy() {
        return CLIENT_AUDIT_STRATEGY;
    }

    @Override
    public MllpAuditStrategy<QueryAuditDataset> getServerAuditStrategy() {
        return SERVER_AUDIT_STRATEGY;
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return CONFIGURATION;
    }

    public NakFactory getNakFactory() {
        return NAK_FACTORY;
    }

    @Override
    public List<Hl7v2Interceptor> getAdditionalConsumerInterceptors() {
        return Collections.singletonList(new ConsumerSegmentEchoingInterceptor("QPD"));
    }
}

