/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.iti10;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.Version;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.HapiContextFactory;
import org.openehealth.ipf.gazelle.validation.profile.HL7v2Transactions;
import org.openehealth.ipf.gazelle.validation.profile.pixpdq.PixPdqTransactions;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.QueryAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti10.Iti10ClientAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.iti10.Iti10ServerAuditStrategy;

public class Iti10Component
extends MllpTransactionComponent<QueryAuditDataset> {
    public static final Hl7v2TransactionConfiguration CONFIGURATION = new Hl7v2TransactionConfiguration(new Version[]{Version.V25}, "PIX adapter", "IPF", ErrorCode.APPLICATION_INTERNAL_ERROR, ErrorCode.APPLICATION_INTERNAL_ERROR, new String[]{"ADT"}, new String[]{"A31"}, new String[]{"ACK"}, new String[]{"*"}, new boolean[]{true}, new boolean[1], HapiContextFactory.createHapiContext((HL7v2Transactions)PixPdqTransactions.ITI10));
    private static final MllpAuditStrategy<QueryAuditDataset> CLIENT_AUDIT_STRATEGY = new Iti10ClientAuditStrategy();
    private static final MllpAuditStrategy<QueryAuditDataset> SERVER_AUDIT_STRATEGY = new Iti10ServerAuditStrategy();
    private static final NakFactory NAK_FACTORY = new NakFactory(CONFIGURATION);

    public Iti10Component() {
    }

    public Iti10Component(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public MllpAuditStrategy<QueryAuditDataset> getClientAuditStrategy() {
        return CLIENT_AUDIT_STRATEGY;
    }

    @Override
    public MllpAuditStrategy<QueryAuditDataset> getServerAuditStrategy() {
        return SERVER_AUDIT_STRATEGY;
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return CONFIGURATION;
    }

    public NakFactory getNakFactory() {
        return NAK_FACTORY;
    }
}

