/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.custom;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.NakFactory;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpAuditStrategy;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpEndpointConfiguration;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionComponent;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpointConfiguration;
import org.springframework.beans.factory.BeanInitializationException;

public class CustomMllpComponent<AuditDatasetType extends MllpAuditDataset>
extends MllpTransactionComponent<AuditDatasetType> {
    private Hl7v2TransactionConfiguration configuration;
    private MllpAuditStrategy<AuditDatasetType> clientAuditStrategy;
    private MllpAuditStrategy<AuditDatasetType> serverAuditStrategy;

    public CustomMllpComponent() {
    }

    public CustomMllpComponent(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    protected MllpTransactionEndpointConfiguration createConfig(Map<String, Object> parameters) throws Exception {
        MllpEndpointConfiguration transactionConfig = super.createConfig((Map)parameters);
        this.configuration = (Hl7v2TransactionConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "hl7TransactionConfig", Hl7v2TransactionConfiguration.class);
        if (this.configuration == null) {
            throw new BeanInitializationException("Must provide hl7TransactionConfig attribute with custom MLLP component");
        }
        this.clientAuditStrategy = (MllpAuditStrategy)this.resolveAndRemoveReferenceParameter(parameters, "clientAuditStrategy", MllpAuditStrategy.class);
        if (transactionConfig.isAudit() && this.clientAuditStrategy == null) {
            throw new BeanInitializationException("Consumer or Producer require ATNA audit, but no clientAuditStrategy is defined for custom MLLP component");
        }
        this.serverAuditStrategy = (MllpAuditStrategy)this.resolveAndRemoveReferenceParameter(parameters, "serverAuditStrategy", MllpAuditStrategy.class);
        if (transactionConfig.isAudit() && this.serverAuditStrategy == null) {
            throw new BeanInitializationException("Consumer or Producer require ATNA audit, but no serverAuditStrategy is defined for custom MLLP component");
        }
        return transactionConfig;
    }

    public Hl7v2TransactionConfiguration getHl7v2TransactionConfiguration() {
        return this.configuration;
    }

    public NakFactory getNakFactory() {
        return new NakFactory(this.configuration);
    }

    @Override
    public MllpAuditStrategy<AuditDatasetType> getClientAuditStrategy() {
        return this.clientAuditStrategy;
    }

    @Override
    public MllpAuditStrategy<AuditDatasetType> getServerAuditStrategy() {
        return this.serverAuditStrategy;
    }
}

