/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.preparser.PreParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StartupListener;
import org.apache.camel.component.mina2.Mina2Consumer;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2AcceptanceException;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.Hl7v2Interceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpDispatchEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.MllpTransactionEndpoint;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.AbstractMllpInterceptor;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerStringProcessingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsumerDispatchingInterceptor
extends AbstractMllpInterceptor<MllpDispatchEndpoint>
implements StartupListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConsumerDispatchingInterceptor.class);
    private final List<String> routeIds = new ArrayList<String>();
    private Map<String, Hl7v2Interceptor> map = new HashMap<String, Hl7v2Interceptor>();

    public ConsumerDispatchingInterceptor(CamelContext camelContext, String ... routeIds) {
        this(camelContext);
        if (routeIds != null && routeIds.length > 0) {
            this.addTransactionRoutes(routeIds);
        }
    }

    public ConsumerDispatchingInterceptor(CamelContext camelContext) {
        try {
            camelContext.addStartupListener((StartupListener)this);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public boolean addTransactionRoutes(String ... routeIds) {
        return this.routeIds.addAll(Arrays.asList(routeIds));
    }

    public void onCamelContextStarted(CamelContext camelContext, boolean alreadyStarted) throws Exception {
        this.collectTransactionTargets(camelContext);
        if (!this.addTargets(camelContext)) {
            LOG.warn("Mllp Dispatcher endpoint exposed without transaction targets. This is probably an error");
        }
    }

    private void collectTransactionTargets(CamelContext camelContext) {
        for (Route route : camelContext.getRoutes()) {
            MllpTransactionEndpoint endpoint;
            if (!(route.getEndpoint() instanceof MllpTransactionEndpoint) || (endpoint = (MllpTransactionEndpoint)route.getEndpoint()).getDispatcher() != this) continue;
            this.addTransactionRoutes(route.getId());
        }
    }

    private boolean addTargets(CamelContext camelContext) throws CamelException {
        for (String routeId : this.routeIds) {
            try {
                Mina2Consumer consumer = (Mina2Consumer)camelContext.getRoute(routeId).getConsumer();
                Hl7v2Interceptor interceptor = (Hl7v2Interceptor)consumer.getProcessor();
                while (!(interceptor instanceof ConsumerStringProcessingInterceptor)) {
                    interceptor = (Hl7v2Interceptor)interceptor.getWrappedProcessor();
                }
                LOG.debug("Adding MLLP transaction route {} to dispatcher", (Object)routeId);
                this.map.put(routeId, (Hl7v2Interceptor)interceptor.getWrappedProcessor());
            }
            catch (NullPointerException e) {
                throw new CamelException("Route with ID='" + routeId + "' not found or is not an IPF MLLP route", (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new CamelException("Route with ID='" + routeId + "' is not an IPF MLLP route", (Throwable)e);
            }
        }
        return !this.map.isEmpty();
    }

    public void process(Exchange exchange) throws Exception {
        String message = (String)exchange.getIn().getBody(String.class);
        String[] fields = PreParser.getFields((String)message, (String[])new String[]{"MSH-9-1", "MSH-9-2", "MSH-9-3", "MSH-12"});
        String messageType = fields[0];
        String triggerEvent = fields[1];
        String messageStructure = fields[2];
        String version = fields[3];
        boolean found = false;
        for (String routeId : this.routeIds) {
            Hl7v2Interceptor interceptor = this.map.get(routeId);
            Hl7v2TransactionConfiguration config = interceptor.getConfigurationHolder().getHl7v2TransactionConfiguration();
            try {
                config.checkMessageAcceptance(messageType, triggerEvent, messageStructure, version, true);
                LOG.debug("Dispatch message with MSH-9-1='{}', MSH-9-2='{}', MSH-9-3='{}', MSH-12='{}' to route '{}'", new Object[]{messageType, triggerEvent, messageStructure, version, routeId});
                found = true;
                interceptor.process(exchange);
                break;
            }
            catch (Hl7v2AcceptanceException hl7v2AcceptanceException) {}
        }
        if (!found) {
            LOG.debug("Nobody can process message with MSH-9-1='{}', MSH-9-2='{}', MSH-9-3='{}', MSH-12='{}'", new Object[]{messageType, triggerEvent, messageStructure, version});
            HL7Exception exception = new HL7Exception("Unsupported message type and/or version", ErrorCode.APPLICATION_INTERNAL_ERROR);
            Exchanges.resultMessage((Exchange)exchange).setBody((Object)this.getNakFactory().createDefaultNak(exception).encode());
        }
    }
}

